/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ToInteger;

public class PdfFontsData {
    private Hashtable font_name_table = new Hashtable();
    private HashMap space_lookup_table = new HashMap();
    private HashMap unicode_name_mapping_table = new HashMap();
    private HashMap diffTable = new HashMap();
    private HashMap widthTable = new HashMap();
    private HashMap scaleXwidthTable = new HashMap();
    private HashMap scaleYwidthTable = new HashMap();
    private HashMap widthTableStandard = new HashMap();
    private String[][] unicode_char_encoding_table = new String[6][335];
    private HashMap unicode_char_decoding_table = new HashMap();
    protected PdfObjectReader current_pdf_file;
    private ClassLoader loader = this.getClass().getClassLoader();
    private HashSet hexCodeTable = new HashSet();
    private HashMap unicode_mappings = new HashMap();
    private Hashtable fontsEncoding = new Hashtable();
    private final String enc = "Cp1252";
    private static final int WIN = 2;
    private static final int STD = 1;
    private static final int MAC = 0;
    private static final short[] ISOAdobeCharset = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228};
    private static final String[] type1CStdStrings = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    private static final short[] ExpertCharset = new short[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    private static final String[] files_names = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
    private static final String[] files_names_bis = new String[]{"CourierNew", "CourierNew,Bold", "CourierNew,BoldItalic", "CourierNew,Italic", "Arial", "Arial,Bold", "Arial,BoldItalic", "Arial,ItalicOblique", "Symbol", "TimesNewRoman,Bold", "TimesNewRoman,BoldItalic", "TimesNewRoman,Italic", "TimesNewRoman", "ZapfDingbats"};
    private static final int ZAPF = 5;
    private static final short[] ExpertSubCharset = new short[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    private static final int SYMBOL = 4;
    private static final int MACEXPERT = 3;

    public PdfFontsData() {
    }

    public void flushFontData() {
        this.diffTable = new HashMap();
        this.widthTable = new HashMap();
        this.scaleXwidthTable = new HashMap();
        this.scaleYwidthTable = new HashMap();
        this.fontsEncoding.clear();
        this.font_name_table.clear();
    }

    public PdfFontsData(PdfObjectReader pdfObjectReader) {
        try {
            this.readDefaultFontInfo();
            this.createUnicodeMappingTable();
            this.createUnicodeMappingTableFromFile(3, "mac_expert.cfg");
            this.createUnicodeMappingTableFromFile(4, "symbol.cfg");
            this.createUnicodeMappingTableFromFile(5, "zapf.cfg");
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading map table");
        }
        this.current_pdf_file = pdfObjectReader;
    }

    public String convertCodeToUnicodeGlyph(int n, String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = null;
        int n2 = this.getFontEncoding(string2);
        String string6 = string;
        string4 = (String)this.unicode_mappings.get(string2 + ":" + n);
        string5 = this.getMappedChar(string2, n);
        if (string4 != null && string5 == null) {
            string3 = "" + (char)Integer.parseInt(string4);
        } else if (string5 != null) {
            String string7 = (String)this.unicode_name_mapping_table.get(string6 + ":" + string5);
            if (string7 != null) {
                string3 = string7;
            } else {
                string7 = (String)this.unicode_name_mapping_table.get(string5);
                if (string7 != null) {
                    string3 = string7;
                } else if (string5.length() > 0) {
                    char c = string5.charAt(0);
                    if (c == 'B' || c == 'C' || c == 'c' || c == 'G') {
                        string5 = string5.substring(1);
                        try {
                            int n3 = this.hexCodeTable.contains("" + string2) ? Integer.valueOf(string5, 16) : Integer.parseInt(string5);
                            string3 = "" + (char)n3;
                        }
                        catch (Exception exception) {
                            string3 = "";
                        }
                    } else {
                        string3 = "";
                    }
                } else {
                    string3 = "";
                }
            }
        } else if (n2 > -1) {
            String string8 = this.unicode_char_encoding_table[n2][n];
            string3 = string8 != null ? string8 : "&#" + n + ";";
        }
        return string3;
    }

    public void readAllTypeFont(HashMap hashMap, String string) throws PdfException {
        try {
            Object object;
            String string2;
            String string3;
            int n;
            Object object2;
            float[] fArray = new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f};
            String string4 = null;
            string4 = (String)hashMap.get("FontMatrix");
            if (string4 != null) {
                object2 = new StringTokenizer(string4, "[] ");
                int n2 = 0;
                while (n2 < 6) {
                    fArray[n2] = Float.parseFloat(((StringTokenizer)object2).nextToken());
                    ++n2;
                }
            }
            object2 = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            String string5 = null;
            string5 = (String)hashMap.get("FontBBox");
            if (string4 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5, "[] ");
                int n3 = 0;
                while (n3 < 4) {
                    object2[n3] = Float.parseFloat(stringTokenizer.nextToken());
                    ++n3;
                }
            }
            float f = 1000.0f / (object2[2] - object2[0]);
            float f2 = 1000.0f / (object2[3] - object2[1]);
            this.putTextXScale(string, f);
            this.putTextYScale(string, f2);
            String string6 = null;
            string6 = (String)hashMap.get("Subtype");
            if (string6 == null) {
                string6 = "";
            }
            if ((n = (string3 = (string3 = this.current_pdf_file.getValue((String)hashMap.get("BaseFont"))) == null ? string : string3.substring(1)).indexOf("+")) != -1) {
                string3 = string3.substring(n + 1);
            }
            this.addFontName(string, string3);
            String string7 = (String)hashMap.get("FirstChar");
            int n4 = 1;
            if (string7 != null) {
                n4 = ToInteger.getInteger(string7);
            }
            String string8 = (String)hashMap.get("LastChar");
            String string9 = this.current_pdf_file.getValue((String)hashMap.get("Widths"));
            if (string9 != null) {
                string2 = string9.substring(1, string9.length() - 1).trim();
                object = new StringTokenizer(string2);
                int n5 = ToInteger.getInteger(string8) + 1;
                int n6 = n4;
                while (n6 < n5) {
                    float f3 = Float.parseFloat(((StringTokenizer)object).nextToken()) * fArray[0];
                    this.putWidth(string, "" + n6, f3);
                    ++n6;
                }
            }
            string2 = null;
            object = string3;
            String string10 = (String)hashMap.get("FontDescriptor");
            HashMap hashMap2 = null;
            if (string10 != null && string10.length() > 1) {
                hashMap2 = this.current_pdf_file.readObjectData(string10, false, false, false);
                String string11 = this.current_pdf_file.getValue((String)hashMap2.get("FontName")).substring(1);
                object = string11;
                n = ((String)object).indexOf("+");
                if (n != -1) {
                    object = ((String)object).substring(n + 1);
                }
                if (string6.equals("/Type1")) {
                    string2 = (String)hashMap2.get("FontFile");
                }
                if (string6.equals("/TrueType")) {
                    string2 = (String)hashMap2.get("FontFile2");
                }
                if (string2 == null && (string2 = (String)hashMap2.get("FontFile3")) != null) {
                    String string12;
                    byte[] byArray = this.current_pdf_file.readStreamObject(string2);
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray)));
                    String string13 = null;
                    while (string13 == null && (string12 = bufferedReader.readLine()) != null) {
                        StringTokenizer stringTokenizer;
                        if (!(string12 = string12.trim()).startsWith("/Subtype") || (stringTokenizer = new StringTokenizer(string12)).countTokens() <= 1) continue;
                        stringTokenizer.nextToken();
                        string13 = stringTokenizer.nextToken();
                    }
                    if (string13 != null) {
                        string6 = string13;
                    }
                }
            }
            this.readEmbeddedFont(string2, hashMap, string, string6, (String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog("Exception " + exception + " reading font");
            System.exit(1);
        }
    }

    public final void addFontName(String string, String string2) {
        this.font_name_table.put(string, string2);
    }

    private final void readDefaultFontInfo() throws Exception {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        BufferedReader bufferedReader = null;
        float f = 200.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < files_names.length) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/pdf/defaults/" + files_names[n9] + ".afm"), "Cp1252"));
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf");
                throw new PdfException("Exception " + exception + " reading lookup table for pdf");
            }
            boolean bl = false;
            while (true) {
                StringTokenizer stringTokenizer;
                try {
                    string = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " reading default fonts");
                }
                if (string == null) break;
                if (string.startsWith("EndCharMetrics")) {
                    bl = false;
                }
                if (string.startsWith("FontBBox")) {
                    stringTokenizer = new StringTokenizer(string);
                    stringTokenizer.nextToken();
                    n5 = Integer.parseInt(stringTokenizer.nextToken());
                    n6 = Integer.parseInt(stringTokenizer.nextToken());
                    n7 = Integer.parseInt(stringTokenizer.nextToken());
                    n8 = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (bl) {
                    stringTokenizer = new StringTokenizer(string, " ;");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals("C")) {
                            string3 = stringTokenizer.nextToken();
                        }
                        if (string2.equals("WX")) {
                            f = Float.parseFloat(stringTokenizer.nextToken()) / 1000.0f;
                        }
                        if (string2.equals("N")) {
                            string4 = stringTokenizer.nextToken();
                        }
                        if (!string2.equals("B")) continue;
                        n = Integer.parseInt(stringTokenizer.nextToken());
                        n2 = Integer.parseInt(stringTokenizer.nextToken());
                        n3 = Integer.parseInt(stringTokenizer.nextToken());
                        n4 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    this.widthTableStandard.put(files_names_bis[n9] + ":" + string4, new Float(f));
                    this.widthTableStandard.put(files_names[n9] + ":" + string4, new Float(f));
                }
                if (!string.startsWith("StartCharMetrics")) continue;
                bl = true;
            }
            ++n9;
        }
    }

    public final String getFontName(String string) {
        return (String)this.font_name_table.get(string);
    }

    public final float getCurrentFontSpaceWidth(String string, String string2, float f) {
        float f2 = -1.0f;
        String string3 = (String)this.space_lookup_table.get(string2);
        int n = 32;
        if (string3 != null) {
            n = Integer.parseInt(string3);
        }
        if ((f2 = this.getWidth(string2, n)) == 0.0f) {
            f2 = 200.0f;
        }
        return f2;
    }

    private String getString(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = null;
        if (n < 391) {
            string = type1CStdStrings[n];
        } else {
            int n5 = n3 + this.getWord(byArray, n2 + (n -= 391) * n4, n4);
            int n6 = n3 + this.getWord(byArray, n2 + (n + 1) * n4, n4);
            int n7 = n6 - n5;
            if (n7 > 255) {
                n7 = 255;
            }
            string = new String(byArray, n5, n7);
        }
        return string;
    }

    private int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 8) + byArray[n + n4];
            ++n4;
        }
        return n3;
    }

    private int getFontEncoding(String string, boolean bl) {
        int n = -1;
        Object var4_4 = null;
        var4_4 = this.fontsEncoding.get(string);
        if (var4_4 == null && bl) {
            n = 1;
        } else if (var4_4 != null) {
            n = var4_4;
        }
        return n;
    }

    public float getWidth(String string, int n) {
        Float f = (Float)this.widthTable.get(string + ":" + n);
        if (f == null) {
            String string2 = this.getMappedChar(string, n);
            f = (Float)this.widthTableStandard.get(this.getFontName(string) + ":" + string2);
            if (f == null) {
                return 0.0f;
            }
            return f.floatValue();
        }
        return f.floatValue();
    }

    private void putTextXScale(String string, float f) {
        this.scaleXwidthTable.put(string, new Float(f));
    }

    public float getTextXScale(String string) {
        Float f = (Float)this.scaleXwidthTable.get(string);
        if (f == null) {
            return 1.0f;
        }
        return f.floatValue();
    }

    public float getTextYScale(String string) {
        Float f = (Float)this.scaleYwidthTable.get(string);
        if (f == null) {
            return 1000.0f;
        }
        return f.floatValue();
    }

    private void putTextYScale(String string, float f) {
        this.scaleYwidthTable.put(string, new Float(f));
    }

    private void putWidth(String string, String string2, float f) {
        this.widthTable.put(string + ":" + string2, new Float(f));
    }

    private void handleType1CFontFile(byte[] byArray, String string) {
        block38: {
            try {
                int n;
                int n2;
                int n3;
                byte by;
                short[] sArray;
                double[] dArray = new double[48];
                int n4 = 0;
                while (n4 < 48) {
                    dArray[n4] = 0.0;
                    ++n4;
                }
                int n5 = byArray[2];
                byte by2 = byArray[3];
                int n6 = this.getWord(byArray, n5, 2);
                byte by3 = byArray[n5 + 2];
                int n7 = (n5 += 3) + (n6 + 1) * by3 - 1;
                int n8 = n7 + this.getWord(byArray, n5, by3);
                int n9 = n7 + this.getWord(byArray, n5 + by3, by3);
                int n10 = n9 - n8;
                if (n10 > 255) {
                    n10 = 255;
                }
                String string2 = new String(byArray, n8, n10);
                n5 = n7 + this.getWord(byArray, n5 + n6 * by3, by3);
                n6 = this.getWord(byArray, n5, 2);
                by3 = byArray[n5 + 2];
                n7 = (n5 += 3) + (n6 + 1) * by3 - 1;
                n8 = n7 + this.getWord(byArray, n5, by3);
                n9 = n7 + this.getWord(byArray, n5 + by3, by3);
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                n4 = 0;
                while (n8 < n9) {
                    if (byArray[n8] <= 27 || byArray[n8] == 31) {
                        int n14;
                        if ((n14 = byArray[n8++]) == 12) {
                            n14 = n14 << 8 | byArray[n8++];
                        }
                        if (n14 == 15) {
                            n11 = (int)dArray[0];
                        } else if (n14 == 16) {
                            n12 = (int)dArray[0];
                        } else if (n14 == 17) {
                            n13 = (int)dArray[0];
                        }
                        n4 = 0;
                        continue;
                    }
                    Vector vector = this.getNum(byArray, n8);
                    double d = (Double)vector.elementAt(0);
                    n8 = (Integer)vector.elementAt(1);
                    if (n4 >= 48) continue;
                    dArray[n4++] = d;
                }
                n5 = n7 + this.getWord(byArray, n5 + n6 * by3, by3);
                int n15 = this.getWord(byArray, n5, 2);
                byte by4 = byArray[n5 + 2];
                int n16 = n5 += 3;
                int n17 = n5 + (n15 + 1) * by4 - 1;
                n5 = n17 + this.getWord(byArray, n5 + n15 * by4, by4);
                n5 = n13;
                int n18 = this.getWord(byArray, n5, 2);
                if (n11 == 0) {
                    sArray = ISOAdobeCharset;
                } else if (n11 == 1) {
                    sArray = ExpertCharset;
                } else if (n11 == 2) {
                    sArray = ExpertSubCharset;
                } else {
                    sArray = new short[n18];
                    sArray[0] = 0;
                    n5 = n11;
                    if ((by = byArray[n5++]) == 0) {
                        n4 = 1;
                        while (n4 < n18) {
                            sArray[n4] = (short)this.getWord(byArray, n5, 2);
                            n5 += 2;
                            ++n4;
                        }
                    } else if (by == 1) {
                        n4 = 1;
                        while (n4 < n18) {
                            n3 = this.getWord(byArray, n5, 2);
                            n5 += 2;
                            n2 = byArray[n5++];
                            n = 0;
                            while (n <= n2) {
                                sArray[n4++] = (short)n3++;
                                ++n;
                            }
                        }
                    } else if (by == 2) {
                        n4 = 1;
                        while (n4 < n18) {
                            n3 = this.getWord(byArray, n5, 2);
                            n2 = this.getWord(byArray, n5 += 2, 2);
                            n5 += 2;
                            n = 0;
                            while (n <= n2) {
                                sArray[n4++] = (short)n3++;
                                ++n;
                            }
                        }
                    }
                }
                if (n12 == 0) {
                    this.putFontEncoding(string, 1);
                    break block38;
                }
                if (n12 == 1) {
                    this.putFontEncoding(string, 3);
                    break block38;
                }
                n5 = n12;
                if (((by = byArray[n5++]) & 0x7F) == 0) {
                    if ((n3 = 1 + byArray[n5++]) > n18) {
                        n3 = n18;
                    }
                    n4 = 1;
                    while (n4 < n3) {
                        n2 = byArray[n5++];
                        String string3 = this.getString(byArray, sArray[n4], n16, n17, by4);
                        this.putMappedChar(string, n2, string3);
                        ++n4;
                    }
                } else if ((by & 0x7F) == 1) {
                    n3 = byArray[n5++];
                    n2 = 1;
                    n4 = 0;
                    while (n4 < n3) {
                        int n19 = byArray[n5++];
                        byte by5 = byArray[n5++];
                        n = 0;
                        while (n <= by5 && n2 < n18) {
                            String string4 = this.getString(byArray, sArray[n2], n16, n17, by4);
                            this.putMappedChar(string, n19, string4);
                            ++n2;
                            ++n19;
                            ++n;
                        }
                        ++n4;
                    }
                }
                if ((by & 0x80) == 0) break block38;
                n3 = byArray[n5++];
                n4 = 0;
                while (n4 < n3) {
                    n2 = byArray[n5++];
                    int n20 = this.getWord(byArray, n5, 2);
                    n5 += 2;
                    String string5 = this.getString(byArray, n20, n16, n17, by4);
                    this.putMappedChar(string, n2, string5);
                    ++n4;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleType1FontFile(byte[] byArray, String string) {
        try {
            block12: {
                String string2;
                String string3;
                BufferedReader bufferedReader;
                block11: {
                    StringReader stringReader = new StringReader(new String(byArray));
                    bufferedReader = new BufferedReader(stringReader);
                    string3 = null;
                    if (!true) break block11;
                    if (string3 != null) return;
                    if ((string2 = bufferedReader.readLine().trim()) == null) break block12;
                }
                do {
                    if (string2.startsWith("/Encoding StandardEncoding def")) {
                        string3 = "STD";
                    } else if (string2.startsWith("/Encoding 256 array")) {
                        string3 = string + ":";
                        while ((string2 = bufferedReader.readLine().trim()) != null) {
                            StringTokenizer stringTokenizer;
                            if (!string2.startsWith("dup") || (stringTokenizer = new StringTokenizer(string2, " /")).countTokens() < 3) continue;
                            try {
                                stringTokenizer.nextToken();
                                String string4 = stringTokenizer.nextToken();
                                String string5 = stringTokenizer.nextToken();
                                int n = Integer.parseInt(string4);
                                this.putMappedChar(string, n, string5);
                                if (!string5.startsWith("B") && !string5.startsWith("C") && !string5.startsWith("c") && !string5.startsWith("G")) continue;
                                String string6 = string5.substring(1);
                                boolean bl = false;
                                int n2 = 0;
                                while (!bl && n2 < string6.length()) {
                                    bl = Character.isLetter(string6.charAt(n2++));
                                }
                                if (!bl) continue;
                                this.hexCodeTable.add("" + string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if (string3 != null) return;
                } while ((string2 = bufferedReader.readLine().trim()) != null);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void readEmbeddedFont(String string, HashMap hashMap, String string2, String string3, String string4) throws PdfException {
        int n = this.getFontEncoding(string2, false);
        String string5 = (String)hashMap.get("Encoding");
        if (string5 != null) {
            if ((n = this.handleFontEncoding(string5, n, string2, string3, string4)) > -1) {
                this.putFontEncoding(string2, n);
            }
        } else {
            this.putFontEncoding(string2, 1);
        }
        if (string != null) {
            if (string3.equals("/Type1")) {
                this.handleType1FontFile(this.current_pdf_file.readStreamObject(string), string2);
            } else {
                this.handleType1CFontFile(this.current_pdf_file.readStreamObject(string), string2);
            }
        }
    }

    private int handleFontEncoding(String string, int n, String string2, String string3, String string4) throws PdfException {
        String string5 = "";
        int n2 = n;
        if (n2 == -1) {
            n2 = string3.equals("/TrueType") ? 0 : 1;
        }
        int n3 = 0;
        HashMap hashMap = new HashMap();
        if (string.indexOf(" ") != -1) {
            String string6;
            hashMap = string.endsWith("R") ? this.current_pdf_file.readObjectData(string, false, false, true) : this.current_pdf_file.decodeStringIntoValue(string, false);
            String string7 = (String)hashMap.get("BaseEncoding");
            if (string7 != null) {
                if (string7.startsWith("/")) {
                    string7 = string7.substring(1);
                }
                string5 = string7;
            }
            if ((string6 = (String)hashMap.get("Differences")) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string6, "[]");
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = "";
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), " \r\n");
                    while (stringTokenizer2.hasMoreTokens()) {
                        string8 = stringTokenizer2.nextToken();
                        if (string8.startsWith("/")) {
                            if ((string8 = string8.substring(1)).startsWith("space")) {
                                this.space_lookup_table.put("" + string2, "" + n3);
                            }
                            this.putMappedChar(string2, n3, string8);
                            if (string8.startsWith("B") || string8.startsWith("c") || string8.startsWith("C") || string8.startsWith("G")) {
                                String string9 = string8.substring(1);
                                boolean bl = false;
                                int n4 = 0;
                                while (!bl && n4 < string9.length()) {
                                    bl = Character.isLetter(string9.charAt(n4++));
                                }
                                if (bl) {
                                    this.hexCodeTable.add("" + string2);
                                }
                            }
                            ++n3;
                            continue;
                        }
                        if (!Character.isDigit(string8.charAt(0))) continue;
                        n3 = Integer.parseInt(string8);
                    }
                }
            }
        } else {
            string5 = string;
        }
        if (string5.indexOf("MacRomanEncoding") != -1) {
            n2 = 0;
        } else if (string5.indexOf("WinAnsiEncoding") != -1) {
            n2 = 2;
        } else if (string5.indexOf("MacExpertEncoding") != -1) {
            n2 = 3;
        } else if (string5.indexOf("STD") == -1 & n2 == -1) {
            LogWriter.writeLog("Encoding type " + string5 + " not implemented");
        }
        return n2;
    }

    private void putMappedChar(String string, int n, String string2) {
        this.diffTable.put(string + ":" + n, string2);
    }

    private Vector getNum(byte[] byArray, int n) {
        String string = "0123456789.ee -";
        char[] cArray = new char[65];
        int n2 = n;
        Vector<Number> vector = new Vector<Number>();
        double d = 0.0;
        byte by = byArray[n2];
        if (by < 28) {
            d = 0.0;
        } else if (by == 28) {
            d = (byArray[n2 + 1] << 8) + byArray[n2 + 2];
            n2 += 3;
        } else if (by == 29) {
            d = (byArray[n2 + 1] << 24) + (byArray[n2 + 2] << 16) + (byArray[n2 + 3] << 8) + byArray[n2 + 4];
            n2 += 5;
        } else if (by == 30) {
            ++n2;
            int n3 = 0;
            while (n3 < 64) {
                byte by2 = byArray[n2++];
                int n4 = by2 >> 4;
                int n5 = by2 & 0xF;
                if (n4 == 15) break;
                cArray[n3++] = string.charAt(n4);
                if (n3 == 64) break;
                if (n4 == 12) {
                    cArray[n3++] = 45;
                }
                if (n3 == 64 || n5 == 15) break;
                cArray[n3++] = string.charAt(n5);
                if (n3 == 64) break;
                if (n5 != 12) continue;
                cArray[n3++] = 45;
            }
            String string2 = new String(cArray, 0, n3);
            try {
                d = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (by == 31) {
            d = 0.0;
        } else if (by < 247) {
            d = by - 139;
            ++n2;
        } else if (by < 251) {
            d = (by - 247 << 8) + byArray[n2 + 1] + 108;
            n2 += 2;
        } else {
            d = -(by - 251 << 8) - byArray[n2 + 1] - 108;
            n2 += 2;
        }
        vector.add(new Double(d));
        vector.add(new Integer(n2));
        return vector;
    }

    private void putFontEncoding(String string, int n) {
        this.fontsEncoding.put(string, new Integer(n));
    }

    private String getMappedChar(String string, int n) {
        String string2 = (String)this.diffTable.get(string + ":" + n);
        if (string2 == null) {
            string2 = (String)this.unicode_char_decoding_table.get(this.getFontEncoding(string) + ":" + n);
        }
        return string2;
    }

    private int getFontEncoding(String string) {
        return this.getFontEncoding(string, true);
    }

    private final void buildLookupTable() {
        LogWriter.writeLog("building lookup table");
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        char c = ' ';
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter("D:\\font_heights.cfg", true));
            int n = 0;
            int n2 = 1;
            while (n2 < 200) {
                Font font = new Font("Lucida", 0, n2);
                int n3 = 0;
                while (n3 < 256) {
                    c = (char)n3;
                    GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, "" + c);
                    Shape shape = glyphVector.getGlyphOutline(0);
                    n = (int)shape.getBounds().getHeight();
                    printWriter.println(n2 + "-" + n3 + " : " + n);
                    ++n3;
                }
                ++n2;
            }
            printWriter.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " attempting to write to debug file");
        }
        LogWriter.writeLog("Table generated");
        System.exit(1);
    }

    private final void handleUnicode(String string, int n) throws PdfException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        BufferedReader bufferedReader = this.current_pdf_file.readUnicodeObjectData(string);
        if (bufferedReader != null) {
            while (true) {
                try {
                    string2 = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception reading unicode object " + exception);
                }
                if (string2 == null || string2.indexOf("endbfrange") != -1) break;
                if (bl) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " <>[]");
                    boolean bl2 = false;
                    if (string2.indexOf("[") != -1) {
                        bl2 = true;
                    }
                    int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                    int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                    int n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                    int n5 = n2;
                    while (n5 < n3 + 1) {
                        if (bl2) {
                            n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                            this.unicode_mappings.put(n + ":" + n5, "" + n4);
                        } else {
                            this.unicode_mappings.put(n + ":" + n5, "" + n4);
                            ++n4;
                        }
                        ++n5;
                    }
                }
                if (string2.indexOf("beginbfrange") == -1) continue;
                bl = true;
            }
        }
    }

    private final void readTrueTypeFont(String string) throws PdfException {
        int n = 0;
        String string2 = "";
        HashMap hashMap = this.current_pdf_file.readObjectData(string, false, false, false);
        this.current_pdf_file.readLine(true);
        long l = this.current_pdf_file.getPointer();
        hashMap = this.current_pdf_file.resolveReferences(hashMap);
        String string3 = (String)hashMap.get("Filter");
        String string4 = (String)hashMap.get("DecodeParms");
        string2 = (String)hashMap.get("Length");
        if (string2 != null) {
            n = new Integer(string2);
        }
        try {
            byte[] byArray = this.current_pdf_file.extractBinaryData(l, n, string3, string4);
            Font.createFont(0, new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " processing TrueType font");
        }
    }

    private final void createUnicodeMappingTableFromFile(int n, String string) throws Exception {
        String string2 = null;
        int n2 = 0;
        BufferedReader bufferedReader = null;
        try {
            BufferedReader bufferedReader2 = bufferedReader = string.equals("symbol.cfg") ? new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/pdf/" + string), "Cp1252")) : new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/pdf/" + string), "UTF-16"));
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open " + string + " to read standard encoding");
                throw new PdfException("Unable to open " + string + " to read standard encoding");
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf");
            throw new PdfException("Exception " + exception + " reading lookup table for pdf");
        }
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            String string4;
            String string5;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (string2.indexOf("space") != -1 || stringTokenizer.countTokens() <= 1) continue;
            if (stringTokenizer.countTokens() == 3) {
                string5 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            } else {
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string5 = "" + (char)Integer.parseInt(string3);
            }
            this.unicode_name_mapping_table.put(n + ":" + string4, string5);
            if (string.equals("zapf.cfg")) {
                this.unicode_name_mapping_table.put(string4, string5);
            }
            if (!Character.isDigit(string3.charAt(0))) continue;
            try {
                n2 = Integer.parseInt(string3, 8);
                this.unicode_char_encoding_table[n][n2] = string5;
                this.unicode_char_decoding_table.put(n + ":" + n2, string4);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with " + n + " value " + string3 + " " + n2);
            }
        }
    }

    private final void createUnicodeMappingTable() throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/pdf/standard_encoding.cfg"), "Cp1252"));
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open standard_encoding.cfg from jar");
                throw new PdfException("Unable to open standard_encoding.cfg from jar");
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf");
            throw new PdfException("Exception " + exception + " reading lookup table for pdf");
        }
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            if (string.indexOf("space") != -1) {
                this.unicode_char_encoding_table[0][32] = string2 = " ";
                this.unicode_char_encoding_table[1][32] = string2;
                this.unicode_char_encoding_table[2][32] = string2;
                this.unicode_name_mapping_table.put("space", string2);
                this.unicode_char_decoding_table.put("0:32", "space");
                this.unicode_char_decoding_table.put("1:32", "space");
                this.unicode_char_decoding_table.put("2:32", "space");
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            this.unicode_name_mapping_table.put(string3, string2);
            if (Character.isDigit(string5.charAt(0))) {
                try {
                    n = Integer.parseInt(string5, 8);
                    this.unicode_char_encoding_table[0][n] = string2;
                    this.unicode_char_decoding_table.put("0:" + n, string3);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " with Mac value " + string5 + " " + n);
                }
            }
            if (Character.isDigit(string4.charAt(0))) {
                try {
                    n3 = Integer.parseInt(string4, 8);
                    this.unicode_char_encoding_table[1][n3] = string2;
                    this.unicode_char_decoding_table.put("1:" + n3, string3);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " with STD value " + string4 + " " + n3);
                }
            }
            if (!Character.isDigit(string6.charAt(0))) continue;
            try {
                n2 = Integer.parseInt(string6, 8);
                this.unicode_char_encoding_table[2][n2] = string2;
                this.unicode_char_decoding_table.put("2:" + n2, string3);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with WIN value " + string6);
            }
        }
    }
}

