/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class PdfHeightTable {
    private int[][] default_height_lookup = new int[200][256];
    private ClassLoader loader = this.getClass().getClassLoader();
    private final String enc = "Cp1252";

    public PdfHeightTable(PdfObjectReader pdfObjectReader) {
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/pdf/font_heights.cfg"), "Cp1252"));
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open font_heights.cfg from jar");
            }
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                int n2 = string.indexOf("-");
                int n3 = string.indexOf(":");
                int n4 = Integer.parseInt(string.substring(0, n2).trim());
                int n5 = Integer.parseInt(string.substring(n2 + 1, n3).trim());
                this.default_height_lookup[n4][n5] = n = Integer.parseInt(string.substring(n3 + 1, string.length()).trim());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading line from height table");
        }
    }

    public final float getCharHeight(int n, int n2) {
        float f = 0.0f;
        if (n2 < 200 & n < 256) {
            f = this.default_height_lookup[n2][n];
        }
        return f;
    }
}

