/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jpedal.fonts.Fonts;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.text.PdfThreshold;
import org.jpedal.utils.LogWriter;

public class PdfGenericGrouping {
    public boolean[] isUsed;
    public float[] mid_x;
    public float[] mid_y;
    public float[] f_x1;
    public float[] f_x2;
    public float[] f_y1;
    public float[] f_y2;
    protected String[] font_data;
    protected boolean[] f_is_horizontal;
    protected int[] line_count;
    protected int[] f_end_font_size;
    protected int[] f_start_font_size;
    protected float[] f_bottom_x1;
    protected float[] f_bottom_x2;
    protected String[] f_font_used;
    protected float[] heights;
    protected float[] space_width;
    protected float[] scaled_space;
    protected String[] names;
    protected float[] col_width;
    protected String[] raw_data;
    protected PdfThreshold current_thresholds;
    protected int[] move_command;
    protected int[] text_length;
    protected int[] token_counter;
    protected PdfPageData page_data = new PdfPageData();
    protected String[] plotting;
    protected PdfData pdf_data;
    protected String[] contents;
    protected int[] f_is_break;
    protected int[] f_is_master;

    public final void decodePageFragments(PdfData pdfData, int n) {
        this.pdf_data = pdfData;
        this.copyDataToFragmentArrays();
        this.removeEncoding();
        this.writeFromFragmentArrays(n);
    }

    public final void writeFromFragmentArrays(int n) {
        int n2 = 1;
        int[] nArray = this.getUnusedFragments();
        n2 = nArray.length;
        List list = this.pdf_data.getBlankTextList();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            String string = this.contents[n4];
            int n5 = (int)this.f_y1[n4];
            int n6 = (int)this.f_y2[n4];
            if (n5 < n6) {
                int n7 = n5;
                n5 = n6;
                n6 = n7;
            }
            String string2 = n + " " + (int)this.f_x1[n4] + " " + n5 + " " + (int)this.f_x2[n4] + " " + n6;
            if (string.toString().trim().length() > 0) {
                Element element = new Element("Value");
                string = Fonts.cleanupTokens(string.toString());
                element.setAttribute("raw_data", this.raw_data[n4]);
                element.setAttribute("page_id", "" + n);
                String string3 = "[" + Fonts.extractFontsList(string) + "]";
                element.setAttribute("fonts_used", "[" + string3 + "]");
                string = "<~START>" + string + "<~END>";
                element.setAttribute("content", string);
                element.setAttribute("plot_string", "" + this.plotting[n4]);
                element.setAttribute("x1", "" + this.f_x1[n4]);
                element.setAttribute("x2", "" + this.f_x2[n4]);
                element.setAttribute("y1", "" + this.f_y1[n4]);
                element.setAttribute("y2", "" + this.f_y2[n4]);
                element.setAttribute("is_master", "" + this.f_is_master[n4]);
                element.setAttribute("shape_data", "" + string2);
                element.setAttribute("line_height", "" + this.heights[n4]);
                list.add(element);
            }
            ++n3;
        }
        this.pdf_data.resetTextList(list);
    }

    public final void removeEncoding() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (!this.isUsed[n3]) {
                this.contents[n3] = this.removeHiddenMarkers(n3);
            }
            ++n2;
        }
    }

    public final void copyDataToFragmentArrays() {
        int n = this.pdf_data.getRawTextElementCount();
        LogWriter.writeLog("Number of fragments extracted :" + n);
        this.isUsed = new boolean[n];
        this.f_is_master = new int[n];
        this.f_is_break = new int[n];
        this.f_font_used = new String[n];
        this.f_start_font_size = new int[n];
        this.mid_x = new float[n];
        this.mid_y = new float[n];
        this.line_count = new int[n];
        this.scaled_space = new float[n];
        this.font_data = new String[n];
        this.f_end_font_size = new int[n];
        this.space_width = new float[n];
        this.token_counter = new int[n];
        this.contents = new String[n];
        this.text_length = new int[n];
        this.plotting = new String[n];
        this.move_command = new int[n];
        this.raw_data = new String[n];
        this.heights = new float[n];
        this.f_is_horizontal = new boolean[n];
        this.f_x1 = new float[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.f_bottom_x1 = new float[n];
        this.f_bottom_x2 = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.token_counter[n2] = this.pdf_data.token_counter[n2];
            this.contents[n2] = this.pdf_data.contents[n2];
            this.heights[n2] = this.pdf_data.heights[n2];
            this.f_is_horizontal[n2] = this.pdf_data.f_is_horizontal[n2];
            this.f_end_font_size[n2] = this.pdf_data.f_end_font_size[n2];
            this.f_font_used[n2] = this.pdf_data.f_font_used[n2];
            this.f_x1[n2] = this.pdf_data.f_x1[n2];
            this.f_x2[n2] = this.pdf_data.f_x2[n2];
            this.f_y1[n2] = this.pdf_data.f_y1[n2];
            this.f_y2[n2] = this.pdf_data.f_y2[n2];
            this.f_bottom_x1[n2] = this.f_x1[n2];
            this.f_bottom_x2[n2] = this.f_x2[n2];
            this.font_data[n2] = this.pdf_data.font_data[n2];
            this.space_width[n2] = this.pdf_data.space_width[n2];
            this.raw_data[n2] = this.pdf_data.raw_data[n2];
            this.plotting[n2] = this.pdf_data.plotting[n2];
            this.text_length[n2] = this.pdf_data.text_length[n2];
            this.move_command[n2] = this.pdf_data.move_command[n2];
            this.mid_x[n2] = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
            this.mid_y[n2] = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            this.f_start_font_size[n2] = this.f_end_font_size[n2];
            this.f_is_break[n2] = -1;
            this.f_is_master[n2] = -1;
            this.line_count[n2] = 1;
            this.scaled_space[n2] = this.space_width[n2] * (float)this.f_end_font_size[n2] / 1000.0f;
            ++n2;
        }
    }

    protected void garbageCollectFragments() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.contents.length) {
            if (!this.isUsed[n2]) {
                this.raw_data[n] = this.raw_data[n2];
                this.contents[n] = this.contents[n2];
                this.line_count[n] = this.line_count[n2];
                this.plotting[n] = this.plotting[n2];
                this.f_x1[n] = this.f_x1[n2];
                this.f_x2[n] = this.f_x2[n2];
                this.f_y1[n] = this.f_y1[n2];
                this.f_y2[n] = this.f_y2[n2];
                this.f_is_master[n] = this.f_is_master[n2];
                this.heights[n] = this.heights[n2];
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        String[] stringArray3 = new String[n];
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        int[] nArray2 = new int[n];
        float[] fArray5 = new float[n];
        this.isUsed = new boolean[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = this.raw_data[n3];
            stringArray2[n3] = this.contents[n3];
            nArray[n3] = this.line_count[n3];
            stringArray3[n3] = this.plotting[n3];
            fArray[n3] = this.f_x1[n3];
            fArray2[n3] = this.f_x2[n3];
            fArray3[n3] = this.f_y1[n3];
            fArray4[n3] = this.f_y2[n3];
            nArray2[n3] = this.f_is_master[n3];
            fArray5[n3] = this.heights[n3];
            this.isUsed[n3] = false;
            ++n3;
        }
        this.raw_data = stringArray;
        this.contents = stringArray2;
        this.line_count = nArray;
        this.plotting = stringArray3;
        this.f_x1 = fArray;
        this.f_x2 = fArray2;
        this.f_y1 = fArray3;
        this.f_y2 = fArray4;
        this.f_is_master = nArray2;
        this.heights = fArray5;
    }

    protected int[] getUnusedFragments() {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            if (!this.isUsed[n3]) {
                nArray[n2] = n3;
                ++n2;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = nArray[n4];
            ++n4;
        }
        return nArray2;
    }

    protected int[] getUnusedFragments(float f, float f2, float f3, float f4) {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            if (!this.isUsed[n3] & (double)this.f_x1[n3] > (double)f - 0.5 & (double)this.f_x2[n3] < (double)f3 + 0.5 & (double)this.f_y2[n3] > (double)f2 - 0.5 & (double)this.f_y1[n3] < (double)f4 + 0.5) {
                nArray[n2] = n3;
                ++n2;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = nArray[n4];
            ++n4;
        }
        return nArray2;
    }

    protected int getFragmentCount() {
        return this.pdf_data.getTextElementCount();
    }

    protected String removeHiddenMarkers(int n) {
        String string = "" + PdfData.marker;
        if (this.contents[n].indexOf(string) == -1) {
            return this.contents[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.contents[n], string, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(string)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuffer = stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

