/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jpedal.color.PdfColor;
import org.jpedal.gui.PdfToolTips;

public class PdfPanel
extends JPanel {
    AffineTransformOp scalingOp;
    AffineTransform af_scaling;
    private int max_y;
    private int y_size = 100;
    private int x_size = 100;
    private int last_page_id;
    private double scaling;
    private PdfToolTips current_tooltips;
    private BufferedImage current_pdf_image;
    private JFrame parent_pane = null;

    public PdfPanel() {
        this.setToolTipText("image preview");
    }

    public final void setImage(BufferedImage bufferedImage) {
        this.current_pdf_image = this.scalingOp.filter(bufferedImage, null);
        int n = this.current_pdf_image.getWidth();
        int n2 = this.current_pdf_image.getHeight();
        if (this.isVisible()) {
            this.paintImmediately(0, 0, n, n2);
        }
        this.x_size = n;
        this.y_size = n2;
    }

    public final void setImage(BufferedImage bufferedImage, int n, double d, int n2) {
        this.current_pdf_image = bufferedImage;
        this.scaling = d;
        this.last_page_id = n2;
        this.max_y = n;
        this.x_size = this.current_pdf_image.getWidth();
        this.y_size = this.current_pdf_image.getHeight();
    }

    public final Dimension getMaximumSize() {
        return new Dimension(this.x_size, this.y_size);
    }

    public final void setToolTips(PdfToolTips pdfToolTips) {
        this.current_tooltips = pdfToolTips;
    }

    public final void flushImage() {
        this.current_pdf_image = null;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(this.x_size, this.y_size);
    }

    public final Dimension getPreferredSize() {
        return new Dimension(this.x_size, this.y_size);
    }

    public final String getToolTipText(MouseEvent mouseEvent) {
        String string = "";
        if (this.current_tooltips != null) {
            Point point = mouseEvent.getPoint();
            Point point2 = new Point(this.screenToScaledCoordsX((int)point.getX()), this.screenToScaledCoordsY((int)point.getY()));
            string = this.current_tooltips.getToolTipText(point2, this.last_page_id);
        }
        return string;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        super.paintComponent(graphics);
        if (this.current_pdf_image != null) {
            graphics2D.drawImage(this.current_pdf_image, null, insets.left, insets.bottom);
        }
    }

    public void initForDecodeDisplay(float f, int n, int n2) {
        this.scaling = f;
        this.x_size = n;
        this.y_size = n2;
        this.af_scaling = new AffineTransform();
        this.af_scaling.scale(f, -f);
        this.af_scaling.translate(0.0, -n2);
        this.scalingOp = new AffineTransformOp(this.af_scaling, PdfColor.hints);
    }

    private final int screenToScaledCoordsX(int n) {
        n = (int)((double)n / this.scaling);
        return n;
    }

    private final int screenToScaledCoordsY(int n) {
        n = this.max_y - (int)((double)n / this.scaling);
        return n;
    }
}

