/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class ImageTransformer {
    private int image_type;
    private BufferedImage current_image;
    private float[][] Trm;
    private float[][] CTM;
    private int max_x;
    private int max_y;
    private int i_x = 0;
    private int i_y = 0;
    private int i_w = 0;
    private int i_h = 0;

    public ImageTransformer(float[][] fArray, int n, int n2, GraphicsState graphicsState, BufferedImage bufferedImage) {
        this.max_x = n;
        this.max_y = n2;
        this.current_image = bufferedImage;
        int n3 = this.current_image.getWidth();
        int n4 = this.current_image.getHeight();
        this.CTM = graphicsState.CTM;
        this.CTM = Matrix.multiply(this.CTM, fArray);
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)n3;
        this.Trm[0][1] = this.CTM[0][1] / (float)n3;
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = this.CTM[1][0] / (float)n4;
        this.Trm[1][1] = this.CTM[1][1] / (float)n4;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        int n5 = 0;
        while (n5 < 3) {
            int n6 = 0;
            while (n6 < 3) {
                if ((double)this.Trm[n6][n5] > 0.99 & this.Trm[n6][n5] < 1.0f) {
                    this.Trm[n6][n5] = 1.0f;
                }
                ++n6;
            }
            ++n5;
        }
        if ((double)this.Trm[0][0] != 1.0 | (double)this.Trm[1][1] != 1.0 | (double)this.Trm[0][1] != 0.0 | (double)this.Trm[1][0] != 0.0) {
            AffineTransform affineTransform = new AffineTransform(this.Trm[0][0], this.Trm[1][0], this.Trm[0][1], this.Trm[1][1], 0.0f, 0.0f);
            Area area = new Area(new Rectangle(0, 0, this.current_image.getWidth(), this.current_image.getHeight()));
            area.transform(affineTransform);
            double d = area.getBounds2D().getY();
            double d2 = area.getBounds2D().getX();
            affineTransform = new AffineTransform((double)this.Trm[0][0], (double)this.Trm[1][0], (double)this.Trm[0][1], (double)this.Trm[1][1], -d2, -d);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
            if (this.CTM[1][0] != 0.0f | this.CTM[0][1] != 0.0f) {
                this.current_image = ObjectStore.convertToARGB(this.current_image);
            }
            this.current_image = affineTransformOp.filter(this.current_image, null);
        }
        this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
        this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
        this.i_x = this.CTM[1][0] < 0.0f ? (int)(this.CTM[2][0] + this.CTM[1][0]) : (int)this.CTM[2][0];
        this.i_y = this.CTM[0][1] < 0.0f ? (int)(this.CTM[2][1] + this.CTM[0][1]) : (int)this.CTM[2][1];
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    public final void clipImage(Area area) {
        Area area2 = (Area)area.clone();
        int n = this.current_image.getWidth();
        int n2 = this.current_image.getHeight();
        double d = 2.0 * area2.getBounds2D().getY() + area2.getBounds2D().getHeight();
        double d2 = area2.getBounds2D().getX();
        double d3 = area2.getBounds2D().getY();
        double d4 = area2.getBounds2D().getWidth();
        double d5 = area2.getBounds2D().getHeight();
        int n3 = (int)((double)n2 - d5);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-d2, -d3);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(d2, -(d3 + d5));
        area2.transform(affineTransform);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(-this.i_x, this.i_y + n3);
        area2.transform(affineTransform2);
        int n4 = (int)area2.getBounds().getX();
        int n5 = (int)area2.getBounds().getY();
        int n6 = (int)area2.getBounds().getWidth();
        int n7 = (int)area2.getBounds().getHeight();
        this.image_type = this.current_image.getType();
        if (this.image_type == 0) {
            this.image_type = 2;
        } else if (this.image_type == 1) {
            this.image_type = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, this.image_type);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!bufferedImage.getColorModel().hasAlpha()) {
            graphics2D.setBackground(Color.white);
            graphics2D.fill(new Rectangle(0, 0, n, n2));
        }
        graphics2D.setClip(area2);
        try {
            graphics2D.drawImage(this.current_image, 0, 0, n, n2, null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " plotting clipping image");
        }
        if (n5 < 0) {
            n7 += n5;
            n5 = 0;
        }
        if (n4 < 0) {
            n6 += n4;
            n4 = 0;
        }
        if (n6 > n) {
            n6 = n;
        }
        if (n7 > n2) {
            n7 = n2;
        }
        if (n5 + n7 > n2) {
            n7 = n2 - n5;
        }
        if (n4 + n6 > n) {
            n6 = n - n4;
        }
        try {
            this.current_image = bufferedImage.getSubimage(n4, n5, n6, n7);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " extracting clipped image");
        }
        double d6 = (double)this.i_x > d2 ? (double)this.i_x : d2;
        double d7 = (double)this.i_y > d3 ? (double)this.i_y : d3;
        this.i_x = (int)d6;
        this.i_y = (int)d7;
        this.i_w = n6;
        this.i_h = n7;
    }
}

