/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class PdfImages {
    public static int dpi = 72;
    private String separator = System.getProperty("file.separator");
    private ClassLoader loader = this.getClass().getClassLoader();
    private String inline_decode_parameters = "";
    private boolean inline_imageMask = false;
    private String inline_decodeArray = "[0 1]";
    private int inline_image_height = 0;
    private String inline_filter_value = "";
    private String temp_dir = System.getProperty("java.io.tmpdir") + this.separator;
    private int inline_image_depth = 0;
    private int inline_image_width = 0;
    private final String enc = "Cp1252";

    public final BufferedImage processInlineImage(byte[] byArray, String string, GraphicsState graphicsState) {
        return this.processImage(byArray, string, this.inline_image_width, this.inline_image_height, this.inline_image_depth, this.inline_filter_value, this.inline_decode_parameters, graphicsState, this.inline_decodeArray, this.inline_imageMask);
    }

    public final BufferedImage processImage(byte[] byArray, String string, int n, int n2, int n3, String string2, String string3, GraphicsState graphicsState, String string4, boolean bl) {
        Object object;
        Object object2;
        if (LogWriter.debug) {
            LogWriter.writeMethod("{process_image}");
        }
        BufferedImage bufferedImage = null;
        String string5 = "jpg";
        if (string2 == null) {
            LogWriter.writeLog("Image " + string + " " + n + "W * " + n2 + "H compressed with No filters at BPC " + n3);
            bufferedImage = this.makeImage(n, n2, n3, byArray, graphicsState);
        } else if (string2.indexOf("/DCTDecode") != -1) {
            LogWriter.writeLog("JPeg Image " + string + " " + n + "W * " + n2 + "H");
            try {
                bufferedImage = this.dataToJPEG(byArray, string);
                if (graphicsState.getNonStrokeColorspaceID() == 3) {
                    bufferedImage = ObjectStore.convertToRGB(bufferedImage);
                    object2 = this.temp_dir + "cmyk" + this.separator;
                    object = new File((String)object2);
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object2 + string + ".jpg");
                    fileOutputStream.write(byArray);
                    fileOutputStream.close();
                    try {
                        ICC_Profile iCC_Profile = ICC_Profile.getInstance(this.loader.getResourceAsStream("org/jpedal/res/cmm/cmyk.icm"));
                        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
                        ColorConvertOp colorConvertOp = new ColorConvertOp(iCC_ColorSpace, PdfColor.hints);
                        bufferedImage = colorConvertOp.filter(bufferedImage, null);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " converting image from CMYK");
                    }
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " covering to JPEG");
            }
            string5 = "jpg";
        } else {
            LogWriter.writeLog("Image " + string + " " + n + "W * " + n2 + "H compressed with " + string2 + " at BPC " + n3);
            bufferedImage = this.makeImage(n, n2, n3, byArray, graphicsState);
            if (n3 == 8 | graphicsState.getNonStrokeColorspaceID() == 2 | graphicsState.getNonStrokeColorspaceID() == 7) {
                string5 = "jpg";
            }
        }
        byArray = null;
        if (dpi != 72) {
            object2 = AffineTransform.getScaleInstance(dpi / 72, dpi / 72);
            object = new AffineTransformOp((AffineTransform)object2, PdfColor.hints);
            bufferedImage = ((AffineTransformOp)object).filter(bufferedImage, null);
        }
        if (bl & n3 == 1) {
            bufferedImage = ObjectStore.convertToARGB(bufferedImage);
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            int n6 = 0;
            int n7 = 0;
            if (string4.indexOf("1 0") != -1) {
                n6 = graphicsState.getNonStrokeColor().getRGB();
            } else {
                n7 = graphicsState.getNonStrokeColor().getRGB();
            }
            int n8 = 0;
            while (n8 < n5) {
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = bufferedImage.getRGB(n9, n8);
                    if (n10 == -16777215) {
                        bufferedImage.setRGB(n9, n8, n6);
                    } else {
                        bufferedImage.setRGB(n9, n8, n7);
                    }
                    ++n9;
                }
                ++n8;
            }
        }
        ObjectStore.saveStoredImage(string, bufferedImage, false, true, string5);
        return bufferedImage;
    }

    public final void setInlineValues(String string, boolean bl, int n, int n2, int n3, String string2, String string3) {
        this.inline_imageMask = bl;
        this.inline_decodeArray = string;
        this.inline_image_width = n;
        this.inline_image_height = n2;
        this.inline_image_depth = n3;
        this.inline_decode_parameters = string2;
        this.inline_filter_value = string3;
    }

    private final BufferedImage dataToJPEG(byte[] byArray, String string) {
        BufferedImage bufferedImage = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
            bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " decoding  " + string + " as JPEG");
        }
        return bufferedImage;
    }

    private final BufferedImage makeImage(int n, int n2, int n3, byte[] byArray, GraphicsState graphicsState) {
        ColorSpace colorSpace = graphicsState.getNonStrokeColorspace();
        int n4 = graphicsState.getNonStrokeColorspaceID();
        int n5 = graphicsState.getNonStrokeColorspaceNumber();
        int n6 = colorSpace.getType();
        int n7 = 0;
        int n8 = colorSpace.getNumComponents();
        byte[] byArray2 = graphicsState.getIndexedColorMap();
        BufferedImage bufferedImage = null;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        if (n3 == 1) {
            try {
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                bufferedImage = new BufferedImage(n, n2, 12);
                bufferedImage.setData(writableRaster);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with 1 bit RGB image");
            }
        } else if (byArray2 != null) {
            n7 = byArray2.length / n8;
            try {
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                IndexColorModel indexColorModel = new IndexColorModel(n3, n7, byArray2, 0, false);
                bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with indexed image. IndexedColorMap size=" + byArray2.length);
            }
        } else if (n8 == 3) {
            if (n * n2 == byArray.length) {
                if (n3 == 8) {
                    bufferedImage = new BufferedImage(n, n2, 13);
                }
                try {
                    WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, n3, null);
                    bufferedImage.setData(writableRaster);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " with RGB image");
                }
            } else {
                try {
                    int[] nArray = new int[]{0, 1, 2};
                    bufferedImage = new BufferedImage(n, n2, 1);
                    WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
                    bufferedImage.setData(writableRaster);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
                }
            }
        } else if (n8 == 1) {
            if (n3 == 8) {
                bufferedImage = new BufferedImage(n, n2, 10);
                try {
                    int[] nArray = new int[]{0};
                    WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n, 1, nArray, null);
                    bufferedImage.setData(writableRaster);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " with 8 bit grayscale image");
                }
            }
        } else {
            LogWriter.writeLog("Image " + n6 + " not currently supported");
        }
        if (bufferedImage.getType() == 0) {
            bufferedImage = ObjectStore.convertToRGB(bufferedImage);
        }
        return bufferedImage;
    }
}

