/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.jpedal.utils.LogWriter;

public class ObjectStore {
    private static String separator = System.getProperty("file.separator");
    private static String temp_dir = System.getProperty("java.io.tmpdir") + separator + "jpedal" + separator;
    private static String key = "";
    private static HashMap image_type = new HashMap();

    public static final boolean saveStoredImage(String string, BufferedImage bufferedImage, String string2) {
        boolean bl = false;
        int n = bufferedImage.getType();
        if (string2.indexOf("tif") != -1) {
            bl = n == 1 | n == 2 ? true : ObjectStore.saveStoredImage("TIFF", ".tif", ".tiff", string, bufferedImage, true, false);
        } else if (string2.indexOf("jpg") != -1) {
            bl = ObjectStore.saveStoredJPEGImage(string, bufferedImage, true, false);
        } else if (string2.indexOf("png") != -1) {
            bl = ObjectStore.saveStoredImage("PNG", ".png", ".png", string, bufferedImage, true, false);
        }
        bufferedImage = null;
        return bl;
    }

    public static final boolean saveStoredImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2, String string2) {
        boolean bl3 = false;
        int n = bufferedImage.getType();
        if (string2.indexOf("tif") != -1) {
            if (n == 1 | n == 2) {
                bl3 = true;
            } else {
                bl3 = ObjectStore.saveStoredImage("TIFF", ".tif", ".tiff", string, bufferedImage, bl, bl2);
                if (!bl) {
                    image_type.put(string, "tif");
                }
            }
        } else if (string2.indexOf("jpg") != -1) {
            if (!bl) {
                image_type.put(string, "jpg");
            }
            bl3 = ObjectStore.saveStoredJPEGImage(string, bufferedImage, bl, bl2);
        } else if (string2.indexOf("png") != -1) {
            bl3 = ObjectStore.saveStoredImage("PNG", ".png", ".png", string, bufferedImage, bl, bl2);
            if (!bl) {
                image_type.put(string, "png");
            }
        }
        bufferedImage = null;
        return bl3;
    }

    public static final String getImageType(String string) {
        return (String)image_type.get(string);
    }

    public static final void init(String string) {
        key = string;
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static final byte[] readBinaryObject(String string) {
        byte[] byArray = null;
        String string2 = temp_dir + key + string + ".bin";
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            while ((n = bufferedInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing data to temp file " + string2);
        }
        return byArray;
    }

    public static final BufferedImage loadStoredImage(String string) {
        String string2 = (String)image_type.get(string);
        BufferedImage bufferedImage = null;
        if (string2 != null) {
            if (string2.equals("tif")) {
                bufferedImage = ObjectStore.loadStoredImage(string, "TIFF", ".tif");
            } else if (string2.equals("jpg")) {
                bufferedImage = ObjectStore.loadStoredJPEGImage(string);
            } else if (string2.equals("png")) {
                bufferedImage = ObjectStore.loadStoredImage(string, "PNG", ".png");
            }
        }
        return bufferedImage;
    }

    public static final BufferedImage convertToRGB(BufferedImage bufferedImage) {
        block2: {
            if (bufferedImage.getType() == 1) break block2;
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 1);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                colorConvertOp.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " removing alpha from JPEG image");
            }
        }
        return bufferedImage;
    }

    public static final BufferedImage convertToARGB(BufferedImage bufferedImage) {
        block2: {
            if (bufferedImage.getType() == 2) break block2;
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                colorConvertOp.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " creating argb image");
            }
        }
        return bufferedImage;
    }

    public static final void flush() {
        if (temp_dir.length() > 2) {
            File file = new File(temp_dir);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().indexOf(key) != -1) {
                    File file2 = new File(temp_dir + stringArray[n]);
                    file2.delete();
                }
                ++n;
            }
        }
    }

    private static final boolean saveStoredJPEGImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        JPEGImageEncoder jPEGImageEncoder;
        BufferedOutputStream bufferedOutputStream;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = string;
        String string3 = "";
        if (!bl) {
            string2 = temp_dir + key + string;
            string3 = temp_dir + key + "R" + string;
            image_type.put("R" + string, image_type.get(string));
        }
        if (!string2.toLowerCase().endsWith(".jpg") & !string2.toLowerCase().endsWith(".jpeg")) {
            string2 = string2 + ".jpg";
            string3 = string3 + ".jpg";
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
            jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
            bufferedOutputStream.close();
            bl4 = true;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage);
        }
        if (!bl4) {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                jPEGImageEncoder.encode(bufferedImage);
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                bl3 = true;
                LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage);
            }
        }
        if (bl2) {
            ObjectStore.saveCopy(string2, string3);
        }
        return bl3;
    }

    private static final BufferedImage loadStoredImage(String string, String string2, String string3) {
        String string4 = temp_dir + key + string + string3;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = JAI.create("fileload", string4).getAsBufferedImage();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " loading " + string);
        }
        return bufferedImage;
    }

    private static final void saveAsJPeg(String string, BufferedImage bufferedImage, boolean bl) {
        block5: {
            JPEGEncodeParam jPEGEncodeParam;
            BufferedOutputStream bufferedOutputStream;
            boolean bl2 = false;
            if (bl) {
                bufferedImage = ObjectStore.convertToRGB(bufferedImage);
            }
            String string2 = string;
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
                jPEGEncodeParam.setQuality(1.0f, true);
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                jPEGImageEncoder.encode(bufferedImage);
                bufferedOutputStream.close();
                bl2 = true;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage);
            }
            if (bl2) break block5;
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                jPEGEncodeParam = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                jPEGEncodeParam.encode(bufferedImage);
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage);
            }
        }
    }

    private static final void saveCopy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
    }

    private static final BufferedImage loadStoredJPEGImage(String string) {
        String string2 = temp_dir + key + string + ".jpg";
        BufferedImage bufferedImage = null;
        File file = new File(string2);
        if (file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading " + string);
            }
        } else {
            bufferedImage = new BufferedImage(100, 100, 1);
        }
        return bufferedImage;
    }

    private static final boolean saveStoredImage(String string, String string2, String string3, String string4, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string5 = string4;
        String string6 = "";
        if (!bl) {
            string5 = temp_dir + key + string4;
            string6 = temp_dir + key + "R" + string4;
            image_type.put("R" + string4, image_type.get(string4));
        }
        if (!string5.toLowerCase().endsWith(string2) & !string5.toLowerCase().endsWith(string3)) {
            string5 = string5 + string2;
            string6 = string6 + string2;
        }
        try {
            RenderedOp renderedOp = JAI.create("filestore", (RenderedImage)bufferedImage, (Object)string5, (Object)string);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            bl3 = true;
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            bl3 = true;
        }
        if (bl2) {
            ObjectStore.saveCopy(string5, string6);
        }
        return bl3;
    }
}

