/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfFileReader {
    private RandomAccessBuffer pdf_datafile = null;
    private Vector_Int offset = new Vector_Int(200);
    private Vector_Int generation = new Vector_Int(200);

    public final long movePointer(String string) throws PdfException {
        long l = this.getOffset(string);
        return this.movePointer(l);
    }

    public final String getType() {
        String string = "";
        try {
            this.movePointer(0L);
            string = this.pdf_datafile.readLine();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in reading type");
        }
        return string;
    }

    public final String readLastLine() {
        String string = null;
        try {
            int n;
            long l = this.pdf_datafile.getFilePointer();
            do {
                this.pdf_datafile.seek(--l);
            } while (!((n = this.pdf_datafile.read()) == 13 | n == 10));
            string = this.pdf_datafile.readLine();
            this.pdf_datafile.seek(l);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading file");
        }
        return string;
    }

    public final void openPdfFile(String string) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessFileBuffer(string, "r");
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(byte[] byArray) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessDataBuffer(byArray);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final long movePointer(long l) throws PdfException {
        long l2;
        block3: {
            l2 = 0L;
            try {
                if (l > this.pdf_datafile.length()) {
                    LogWriter.writeLog("Attempting to access ref outside file");
                    break block3;
                }
                l2 = this.getPointer();
                this.pdf_datafile.seek(l);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " moving pointer in file");
            }
        }
        return l2;
    }

    public final long getPointer() {
        long l = 0L;
        try {
            l = this.pdf_datafile.getFilePointer();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting pointer in file");
        }
        return l;
    }

    public final void closePdfFile() {
        try {
            this.pdf_datafile.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing file");
        }
    }

    public final String readLine(boolean bl) {
        String string = null;
        try {
            string = this.pdf_datafile.readLine();
            if (bl) {
                string = this.validateLine(string);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading line");
        }
        return string;
    }

    protected final byte[] readBinaryObject(long l, long l2) {
        byte[] byArray = new byte[(int)l2];
        try {
            long l3 = this.movePointer(l);
            this.pdf_datafile.read(byArray);
            this.movePointer(l3);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading data for XOBject from file");
        }
        return byArray;
    }

    protected final void checkOffsets(int n) {
        int n2 = 1;
        while (n2 < n) {
            int n3 = this.offset.elementAt(n2);
            try {
                this.movePointer(n2 + " 0 R");
                String string = this.readLastLine();
                if (string.indexOf(" 0 obj") == -1) {
                    string = this.readLastLine();
                }
                if (!string.startsWith(n2 + " 0 obj")) {
                    LogWriter.writeLog(n3 + " Reference not valid for " + n2 + ">" + string + "<");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    protected final void storeObjectOffset(int n, int n2, int n3) {
        int n4 = 0;
        n4 = this.generation.elementAt(n);
        if (n4 <= n3 | this.offset.elementAt(n) == 0) {
            this.offset.setElementAt(n2, n);
            this.generation.setElementAt(n3, n);
        }
    }

    protected final void moveToEOF() throws PdfException {
        String string = "";
        try {
            this.movePointer(this.pdf_datafile.length() - 1024L);
            while ((string = this.readLine(true)).indexOf("%%EOF") == -1) {
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to find End of File marker in last 1024 bytes");
            throw new PdfException("Unable to find End of File marker in last 1024 bytes");
        }
    }

    protected final String findOffsets() {
        String string;
        String string2 = "";
        try {
            this.movePointer(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while ((string = this.readLine(false)) != null) {
            int n;
            int n2 = (int)this.getPointer();
            if (string.indexOf(" obj") != -1) {
                n = string.indexOf(" ");
                if (n <= -1) continue;
                int n3 = Integer.parseInt(string.substring(0, n));
                this.storeObjectOffset(n3, n2, 1);
                continue;
            }
            if (string.indexOf("Root") == -1 || (n = string.indexOf(" ")) <= -1) continue;
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    protected final byte[] readASCIIObject(long l, long l2) {
        byte[] byArray = new byte[(int)l2];
        String string = "";
        int n = 0;
        try {
            this.movePointer(l);
            while ((string = this.readLine(false)).indexOf("endstream") == -1) {
                int n2 = 0;
                while (n2 < string.length()) {
                    byArray[n] = (byte)string.charAt(n2);
                    ++n;
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading data for ASCIII from file");
        }
        return byArray;
    }

    private final int convertReference(String string) {
        int n = 0;
        if ((string = Strip.removeArrayMarkers(string)).endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("Error with reference .." + string);
        }
        return n;
    }

    private final String validateLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 32;
        int n2 = 32;
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            n2 = string.charAt(n4);
            if (n2 == 47 && n != 32) {
                stringBuffer.append(' ');
                ++n3;
            }
            if (n2 == 40 & n != 32 & n != 92) {
                stringBuffer.append(' ');
                ++n3;
            }
            if (n2 == 91 && n != 32) {
                stringBuffer.append(' ');
                ++n3;
            }
            if (n4 > 2 && n2 == 60 && n == 60 && stringBuffer.charAt(n3 - 1) != ' ') {
                stringBuffer.insert(n3 - 1, ' ');
                ++n3;
            }
            stringBuffer.append((char)n2);
            ++n3;
            n = n2;
            ++n4;
        }
        string = stringBuffer.toString();
        return string;
    }

    private final int getOffset(String string) {
        int n = this.convertReference(string);
        return this.offset.elementAt(n);
    }

    private final int countTimes(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        while (n3 > 0) {
            n3 = string.indexOf(string2, n2);
            if (n3 == -1) continue;
            ++n;
            n2 = n3 + 1;
        }
        return n;
    }

    private final int getOffset(int n) {
        return this.offset.elementAt(n);
    }
}

