/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.InflaterInputStream;
import org.jpedal.io.PdfFileReader;
import org.jpedal.sun.TIFFFaxDecoder;
import org.jpedal.sun.TIFFLZWDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_String;

public class PdfFilteredReader
extends PdfFileReader {
    private int image_width = 0;
    private int image_height = 0;
    private int bytes_needed = 0;
    private int image_depth = 0;
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};

    public final void setImageSize(int n, int n2, int n3) {
        int n4 = n;
        if ((n4 & 7) > 0) {
            n4 = n4 - (n4 & 7) + 8;
        }
        this.image_width = n;
        this.image_height = n2;
        this.image_depth = n3;
        this.bytes_needed = n4 * n2 * n3 / 8;
    }

    public final byte[] decodeFilters(byte[] byArray, long l, long l2, String string, String string2) {
        boolean bl = true;
        if (string2 == null) {
            string2 = "";
        }
        byte[] byArray2 = null;
        if (string == null) {
            byArray2 = byArray == null ? this.readBinaryObject(l, l2) : byArray;
        } else {
            if (string.startsWith("[")) {
                string = string.substring(1);
            }
            if (string.endsWith("]")) {
                string = string.substring(0, string.length() - 1);
            }
            Vector_String vector_String = new Vector_String(10);
            if (string.length() == 0) {
                byArray2 = byArray == null ? this.readBinaryObject(l, l2) : byArray;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    vector_String.addElement(stringTokenizer.nextToken());
                }
                int n = 0;
                while (n < vector_String.size()) {
                    String string3 = vector_String.elementAt(n);
                    if (string3.startsWith("/")) {
                        if (bl) {
                            bl = false;
                            if (string3.indexOf("ASCII") != -1) {
                                if (byArray == null) {
                                    byArray2 = this.readASCIIObject(l, l2);
                                } else {
                                    LogWriter.writeLog("Unable to decode ASCII inline images");
                                }
                            } else {
                                byArray2 = byArray == null ? this.readBinaryObject(l, l2) : byArray;
                            }
                        }
                        if (string3.indexOf("/FlateDecode") != -1) {
                            byArray2 = PdfFilteredReader.flateDecode(byArray2, string2);
                        } else if (string3.indexOf("/ASCII85Decode") != -1) {
                            byArray2 = PdfFilteredReader.ascii85Decode(byArray2);
                        } else if (string3.indexOf("/CCITT") != -1) {
                            byArray2 = this.ccittDecode(byArray2, string, string2);
                        } else if (string3.indexOf("/LZW") != -1) {
                            byArray2 = this.lzwDecode(byArray2, string, string2);
                        }
                    }
                    ++n;
                }
            }
        }
        return byArray2;
    }

    private final byte[] lzwDecode(byte[] byArray, String string, String string2) {
        int n = 1;
        int n2 = 8;
        byte[] byArray2 = new byte[this.bytes_needed];
        HashMap hashMap = this.getValuesAsHashMap(string2);
        String string3 = (String)hashMap.get("/Predictor");
        if (string3 != null) {
            n = Integer.parseInt(string3);
        }
        if ((string3 = (String)hashMap.get("/BitsPerComponent")) != null) {
            n2 = Integer.parseInt(string3);
        }
        try {
            TIFFLZWDecoder tIFFLZWDecoder = new TIFFLZWDecoder(this.image_width, n, n2);
            tIFFLZWDecoder.decode(byArray, byArray2, this.image_height);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing LZW filter");
        }
        return byArray2;
    }

    private final HashMap getValuesAsHashMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "< >");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("/")) continue;
            String string3 = stringTokenizer.nextToken();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private final byte[] ccittDecode(byte[] byArray, String string, String string2) {
        byte[] byArray2;
        block10: {
            byArray2 = new byte[this.bytes_needed];
            boolean bl = false;
            int n = 1728;
            int n2 = 0;
            int n3 = 0;
            HashMap hashMap = this.getValuesAsHashMap(string2);
            String string3 = (String)hashMap.get("/K");
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
            }
            if ((string3 = (String)hashMap.get("/Blackls1")) != null) {
                bl = Boolean.getBoolean(string3);
            }
            n2 = this.image_height;
            n = this.image_width;
            try {
                TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(1, n, n2);
                if (n3 == 0) {
                    tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n2);
                } else if (n3 > 0) {
                    tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n2, 0L);
                } else if (n3 < 0) {
                    tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n2, 0L);
                }
                if (bl) break block10;
                int n4 = 0;
                while (n4 < byArray2.length) {
                    byArray2[n4] = (byte)(255 - byArray2[n4]);
                    ++n4;
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " accessing CCITT filter");
            }
        }
        return byArray2;
    }

    private static final byte[] ascii85Decode(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n3] == 122) {
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        long l = 0L;
        byte[] byArray2 = new byte[n + 1 + n2 * 3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n - 5) {
            int n7;
            l = 0L;
            if (byArray[n6] == 122) {
                n6 -= 4;
                n7 = 0;
                while (n7 < 4) {
                    byArray2[n4] = 0;
                    ++n4;
                    ++n7;
                }
            } else if (byArray[n6] > 32 & byArray[n6] < 118) {
                n5 = 0;
                while (n5 < 5) {
                    l += (long)(byArray[n6 + n5] - 33) * base_85_indices[n5];
                    ++n5;
                }
                n7 = 0;
                while (n7 < 4) {
                    byArray2[n4] = (byte)(l / hex_indices[n7] & 0xFFL);
                    ++n4;
                    ++n7;
                }
            }
            n6 += 5;
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    private static final byte[] flateDecode(byte[] byArray, String string) {
        byte[] byArray2 = new byte[]{};
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray)));
            byte[] byArray3 = new byte[4096];
            while ((n = inflaterInputStream.read(byArray3)) != -1) {
                byteArrayOutputStream.write(byArray3, 0, n);
            }
            inflaterInputStream.close();
            byteArrayOutputStream.close();
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception.getMessage() + " inflating data with flate filter");
        }
        return byArray2;
    }
}

