/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.StatusBar;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_String;

public class PdfObjectReader
extends PdfFilteredReader {
    private boolean is_encrypted = false;
    private String[] information_values = new String[9];
    private static final String[] information_fields = new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer", "CreationDate", "ModDate", "Trapped"};

    public final String readReferenceTable(boolean bl) throws PdfException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Vector_Int vector_Int = new Vector_Int();
        int n5 = 0;
        int n6 = 0;
        HashMap hashMap = null;
        boolean bl2 = false;
        this.movePointer(0L);
        int n7 = 0;
        while (n7 < 50) {
            string4 = this.readLine(true);
            if (string4 == null) {
                n7 = 50;
            } else if (string4.indexOf("/Linearized") != -1) {
                bl2 = true;
            }
            if (bl2) {
                n7 = 50;
            }
            ++n7;
        }
        this.moveToEOF();
        string4 = this.readLastLine();
        if (string4 == null) {
            string4 = this.readLastLine();
        }
        while (string4.indexOf("xref") == -1) {
            string4 = this.readLastLine();
            if (string4.indexOf("startxref") == -1) continue;
            string4 = "";
        }
        this.readLine(true);
        vector_Int.addElement((int)this.getPointer());
        while (string4.indexOf("trailer") == -1) {
            string4 = this.readLine(true);
        }
        StatusBar.updateStatus("Looking for cross-reference tables", 1);
        hashMap = this.readObjectData(false, false);
        string4 = this.readLine(true);
        if (string4.indexOf("startxref") != -1) {
            n5 = Integer.parseInt(this.readLine(true).trim());
        }
        vector_Int.addElement(n5);
        string2 = (String)hashMap.get("Prev");
        if (string2 != null) {
            n3 = Integer.parseInt(string2);
            vector_Int.addElement(n3);
        }
        while (n3 != 0) {
            this.movePointer(n3);
            hashMap = this.readObjectData(false, false);
            string2 = (String)hashMap.get("Prev");
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
                vector_Int.addElement(n3);
                continue;
            }
            n3 = 0;
        }
        int n8 = vector_Int.size() - 2;
        while (n8 > -1) {
            n5 = vector_Int.elementAt(n8);
            this.movePointer(n5);
            string4 = this.readLastLine();
            if (string4.indexOf("xref") == -1) {
                string4 = this.readLastLine();
                this.readLine(true);
            }
            this.readLine(true);
            if (string4.indexOf("xref") != -1) {
                Vector_String vector_String = new Vector_String(200);
                while (string4.indexOf("trailer") == -1) {
                    string4 = this.readLine(true).trim();
                    vector_String.addElement(string4);
                }
                hashMap = this.readObjectData(false, false);
                string2 = (String)hashMap.get("Root");
                if (string2 != null) {
                    string = string2;
                }
                this.processEncryption(hashMap, bl);
                int n9 = 0;
                while (n9 < vector_String.size() - 2) {
                    string4 = vector_String.elementAt(n9);
                    if (string4.indexOf("xref") == -1) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string4);
                        if (stringTokenizer.countTokens() == 2) {
                            n6 = Integer.parseInt(stringTokenizer.nextToken());
                        } else {
                            n = Integer.parseInt(stringTokenizer.nextToken());
                            n2 = Integer.parseInt(stringTokenizer.nextToken());
                            string3 = stringTokenizer.nextToken();
                            if (string3.equals("n")) {
                                this.storeObjectOffset(n6, n, n2);
                                if (n6 > n4) {
                                    n4 = n6;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n9;
                }
                string2 = (String)hashMap.get("Info");
                if (string2 != null) {
                    this.readInformationObject(string2);
                }
            } else {
                LogWriter.writeLog("Corrupt xref table - find objects manually");
                string = this.findOffsets();
            }
            --n8;
        }
        this.checkOffsets(n4);
        return string;
    }

    public final HashMap decodeStringIntoValue(String string, boolean bl) {
        StringTokenizer stringTokenizer;
        boolean bl2 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        string = Strip.stripMainBraces(string);
        if (bl) {
            string = Strip.removeEscapedBrackets(string);
        }
        if ((stringTokenizer = new StringTokenizer(string, " ")).countTokens() != 5) {
            while (stringTokenizer.hasMoreTokens()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    string2 = stringTokenizer.nextToken();
                }
                string3 = string2.substring(1);
                n3 = string3.indexOf("[");
                if (n3 != -1 & string3.startsWith("ID")) {
                    string4 = string3.substring(n3 + 1);
                    string3 = string3.substring(0, n3);
                } else {
                    int n4;
                    string4 = stringTokenizer.nextToken();
                    if (string4.startsWith("[")) {
                        while (string4.indexOf("]") == -1) {
                            string4 = string4 + " " + stringTokenizer.nextToken();
                        }
                    } else if (string4.startsWith("(")) {
                        n4 = 1;
                        int n5 = 0;
                        if (string4.indexOf(")") != -1) {
                            ++n5;
                        }
                        while (n4 != n5) {
                            String string5 = stringTokenizer.nextToken();
                            if (string5.indexOf(")") != -1) {
                                ++n5;
                            }
                            if (string5.indexOf("(") != -1) {
                                ++n4;
                            }
                            string4 = string4 + " " + string5;
                        }
                    } else if (string4.equals("<<")) {
                        while (!((n = this.countTimes(string4 = string4 + " " + stringTokenizer.nextToken(), "<<")) == (n2 = this.countTimes(string4, ">>")) & n > 0)) {
                        }
                    } else {
                        n4 = 1;
                        while (n4 == 1) {
                            if (stringTokenizer.hasMoreTokens()) {
                                String string6 = stringTokenizer.nextToken();
                                if (string6.startsWith("/")) {
                                    string2 = string6;
                                    bl2 = true;
                                    n4 = 0;
                                    continue;
                                }
                                string4 = string4 + " " + string6 + " " + stringTokenizer.nextToken();
                                continue;
                            }
                            n4 = 0;
                        }
                    }
                }
                string4 = string4.trim();
                hashMap.put(string3, string4);
                if (stringTokenizer.hasMoreTokens()) continue;
                break;
            }
        }
        return hashMap;
    }

    public final String isObjectList(String string, boolean bl) throws PdfException {
        String string2 = null;
        long l = this.getPointer();
        this.movePointer(string);
        String string3 = this.readObjectDataLine(bl).trim();
        if (string3.startsWith("[")) {
            string2 = string3;
        }
        this.movePointer(l);
        return string2;
    }

    public final String getValue(String string) throws PdfException {
        String string2 = "";
        String string3 = "";
        long l = this.getPointer();
        if (string != null && string.endsWith(" R")) {
            this.movePointer(string);
            while (true) {
                int n;
                if ((n = (string3 = this.readLine(true).trim()).indexOf(" obj")) != -1) {
                    string3 = string3.substring(n + 4).trim();
                }
                if (string3.indexOf("endobj") != -1) break;
                string2 = string2 + string3 + " ";
            }
            string = string2.trim();
            this.movePointer(l);
        }
        return string;
    }

    public final byte[] readStreamObject(String string) throws PdfException {
        byte[] byArray = null;
        if (string.indexOf("/") == -1) {
            this.movePointer(string + " R");
            byArray = this.readStreamObject();
        } else {
            String string2 = "";
            String string3 = string.substring(1).trim();
            while (string2.indexOf("stream") == -1) {
                string2 = this.readLine(true);
            }
            long l = this.getPointer();
            while (string2.indexOf("endstream") == -1) {
                string2 = this.readLine(true);
            }
            long l2 = this.getPointer() - 10L;
            try {
                byArray = this.decodeFilters(null, l, l2 - l, string3, "");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " decoding stream");
            }
        }
        return byArray;
    }

    public final byte[] readStreamObject() throws PdfException {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        long l = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (string2.indexOf("stream") == -1) {
            string2 = this.readLine(true).trim();
            if (string2.endsWith(" obj")) {
                string2 = this.readLine(true).trim();
            }
            if ((n2 = string2.indexOf("/Length ") + 8) != 7) {
                String string4;
                int n5;
                n3 = string2.length();
                n4 = string2.indexOf(">>", n2);
                if (n4 == -1) {
                    n4 = n3;
                }
                if ((n5 = string2.indexOf("/", n2)) == -1) {
                    n5 = n3;
                }
                if (n5 < n3) {
                    n3 = n5;
                }
                if (n4 < n3) {
                    n3 = n4;
                }
                if (((StringTokenizer)(object = new StringTokenizer(string4 = string2.substring(n2, n3).trim()))).countTokens() == 1) {
                    try {
                        n = Integer.parseInt(((StringTokenizer)object).nextToken());
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " getting object length");
                    }
                } else {
                    String string5;
                    long l2 = this.getPointer();
                    this.movePointer(string4);
                    while ((string5 = this.readLine(true).trim()).indexOf("endobj") == -1) {
                        string3 = string5;
                    }
                    n = Integer.parseInt(string3);
                    this.movePointer(l2);
                }
            }
            object = new StringTokenizer(string2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken();
                if (string3.indexOf("Filter") != -1) {
                    string = ((StringTokenizer)object).nextToken();
                }
                if (string.indexOf("[") == -1) continue;
                while (string.indexOf("]") == -1) {
                    string = string + " " + ((StringTokenizer)object).nextToken();
                }
            }
        }
        if (string2.startsWith("stream") | string2.startsWith(">>stream")) {
            l = this.getPointer();
        }
        StatusBar.updateStatus("Extracting content from stream", 1);
        object = null;
        this.setImageSize(n * 15, 1, 8);
        try {
            object = this.decodeFilters(null, l, n, string, "");
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " decoding stream");
        }
        return object;
    }

    public final byte[] getICCData(String string) throws PdfException {
        byte[] byArray = null;
        if (string.endsWith("R")) {
            this.movePointer(string);
            HashMap hashMap = this.readObjectData(false, false);
            long l = Long.parseLong((String)hashMap.get("Length"));
            String string2 = (String)hashMap.get("Filter");
            String string3 = (String)hashMap.get("DecodeParms");
            this.readLine(true);
            long l2 = this.getPointer();
            byArray = this.decodeFilters(null, l2, l, string2, string3);
        } else {
            LogWriter.writeLog(string + " not currently supported");
        }
        return byArray;
    }

    public final byte[] getIndexedColorMap(String string, int n) throws PdfException {
        byte[] byArray = null;
        if (string.endsWith("R")) {
            this.movePointer(string);
            HashMap hashMap = this.readObjectData(false, false);
            String string2 = this.getValue((String)hashMap.get("Length"));
            long l = Long.parseLong(string2);
            String string3 = this.getValue((String)hashMap.get("Filter"));
            String string4 = (String)hashMap.get("DecodeParms");
            this.readLine(true);
            long l2 = this.getPointer();
            byArray = this.decodeFilters(null, l2, l, string3, string4);
        } else {
            LogWriter.writeLog("Direct ICC Not currently supported");
        }
        return byArray;
    }

    public final BufferedReader readUnicodeObjectData(String string) throws PdfException {
        HashMap hashMap = new HashMap();
        this.movePointer(string);
        hashMap = this.readObjectData(false, false);
        this.readLine(true);
        long l = this.getPointer();
        BufferedReader bufferedReader = null;
        try {
            int n = Integer.parseInt(this.getValue((String)hashMap.get("Length")));
            String string2 = this.getValue((String)hashMap.get("Filter"));
            byte[] byArray = this.decodeFilters(null, l, n, string2, "");
            bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception setting up unicode object " + exception);
        }
        return bufferedReader;
    }

    public final String readXObjectHeader(String string) throws PdfException {
        this.movePointer(string);
        String string2 = "";
        String string3 = "";
        this.readLine(true);
        while ((string3 = this.readLine(true).trim()).indexOf("endobj") == -1) {
            string2 = string2 + " " + string3;
        }
        string2 = Strip.stripMainBraces(string2);
        return string2;
    }

    public final String[] getInformation() {
        return this.information_values;
    }

    public final HashMap readObjectData(String string, boolean bl, boolean bl2, boolean bl3) throws PdfException {
        long l = this.getPointer();
        this.movePointer(string);
        String string2 = this.readObjectDataLine(bl);
        if (bl3) {
            this.movePointer(l);
        }
        return this.decodeStringIntoValue(string2, bl2);
    }

    public final HashMap resolveReferences(HashMap hashMap) throws PdfException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String string = (String)hashMap.get(k);
            if (!string.endsWith(" R")) continue;
            this.movePointer(string);
            String string2 = "";
            String string3 = "";
            this.readLine(true);
            while ((string3 = this.readLine(true).trim()).indexOf("endobj") == -1) {
                string2 = string2 + " " + string3;
            }
            hashMap.put(k, string2.trim());
        }
        return hashMap;
    }

    public final boolean isEncrypted() {
        return this.is_encrypted;
    }

    public final String readRef(String string, String string2) throws PdfException {
        this.movePointer(string2);
        this.readLine(true);
        String string3 = this.readLine(true);
        if (string3.indexOf("[") != -1) {
            while (string3.indexOf("]") == -1) {
                string3 = string3 + this.readLine(true);
            }
            int n = string3.indexOf("[");
            int n2 = string3.indexOf("]");
            string = string3 = string3.substring(n, n2).trim();
        }
        return string;
    }

    public final String readObjectDataLine(String string, boolean bl) throws PdfException {
        this.movePointer(string);
        return this.readObjectDataLine(bl);
    }

    public final String readObjectDataLine(boolean bl) {
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        while (!bl2) {
            try {
                string = this.readLine(true);
                if (string.indexOf("%%EOF") != -1) break;
                if (string.startsWith("%Begin")) {
                    String string3 = "";
                    do {
                        string3 = string;
                        string = this.readLine(true).trim();
                    } while (!string3.startsWith("%End"));
                }
                while (string.endsWith("\\")) {
                    string = string.substring(0, string.length() - 1) + this.readLine(true).trim();
                }
                if (bl) {
                    LogWriter.writeLog(string);
                }
                if ((n = this.countTimes(string2 = string2 + " " + string, "<<")) == (n2 = this.countTimes(string2, ">>")) & n > 0) {
                    bl2 = true;
                }
                if (n != 0 || string.indexOf("endobj") == -1) continue;
                bl2 = true;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading object details");
            }
        }
        if (string2.endsWith(" endobj")) {
            int n3 = string2.lastIndexOf(" ");
            string2 = string2.substring(0, n3);
        }
        return string2;
    }

    public final byte[] extractBinaryData(long l, long l2, String string, String string2) {
        byte[] byArray = null;
        byArray = string != null && string.startsWith("/DCTDecode") ? this.readBinaryObject(l, l2) : this.decodeFilters(null, l, l2, string, string2);
        return byArray;
    }

    public final void processEncryption(HashMap hashMap, boolean bl) {
        String string = (String)hashMap.get("Encrypt");
        if (string != null) {
            LogWriter.writeLog("Program will not decode encrypted pdf files");
            this.is_encrypted = true;
            if (bl) {
                ShowGUIMessage.showGUIMessage("Software will not decode encrypted files", "File Encrypted");
            }
        }
    }

    public static final String[] getInformationFields() {
        return information_fields;
    }

    private final HashMap readObjectData(boolean bl, boolean bl2) {
        String string = this.readObjectDataLine(bl);
        return this.decodeStringIntoValue(string, bl2);
    }

    private final int countTimes(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        while (n3 > -1) {
            n3 = string.indexOf(string2, n2);
            if (n3 == -1) continue;
            ++n;
            n2 = n3 + 2;
        }
        return n;
    }

    private final void readInformationObject(String string) throws PdfException {
        LogWriter.writeLog("Information object present");
        long l = this.movePointer(string);
        HashMap hashMap = this.readObjectData(false, true);
        int n = 0;
        while (n < information_fields.length) {
            this.information_values[n] = (String)hashMap.get(information_fields[n]);
            ++n;
        }
        this.movePointer(l);
    }
}

