/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import org.jpedal.io.RandomAccessBuffer;

public class RandomAccessDataBuffer
implements RandomAccessBuffer {
    private byte[] data;
    private long pointer;

    public RandomAccessDataBuffer(byte[] byArray) {
        this.data = byArray;
        this.pointer = -1L;
    }

    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    public void seek(long l) throws IOException {
        if (!this.checkPos(l)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = l;
    }

    public void close() throws IOException {
        this.data = null;
        this.pointer = -1L;
    }

    public long length() throws IOException {
        if (this.data != null) {
            return this.data.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer++]);
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            return RandomAccessDataBuffer.b2i(this.data[(int)this.pointer]);
        }
        return -1;
    }

    public String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) >= 0) {
            if (n == 10 || n == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == n) break;
                this.read();
                break;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public int read(byte[] byArray) throws IOException {
        int n = -1;
        if (this.checkPos(this.pointer)) {
            n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = this.data[(int)this.pointer++];
                ++n;
                if (!this.checkPos(this.pointer)) break;
                ++n2;
            }
        }
        return n;
    }

    private static final int b2i(byte n) {
        int n2 = n >= 0 ? n : 256 + n;
        return n2;
    }

    private boolean checkPos(long l) throws IOException {
        return l >= 0L && l < this.length();
    }
}

