/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import org.jpedal.utils.LogWriter;

public class StatusBar {
    private static int debug_level = 0;
    private static int progress_size = 0;
    private static int progress_max_size = 100;
    private static JProgressBar status = null;
    private static boolean use_client = false;

    public static final void initialiseStatus(String string, int n) {
        progress_size = 0;
        debug_level = n;
        status = new JProgressBar();
        status.setForeground(Color.red);
        status.setStringPainted(true);
        status.setMaximum(progress_max_size);
        status.setMinimum(0);
        StatusBar.updateStatus(string, 4);
    }

    public static final void updateStatus(String string, int n) {
        if (use_client) {
            status.setString(string);
            status.setValue(progress_size);
            int n2 = (int)status.getSize().getWidth();
            int n3 = (int)status.getSize().getHeight();
            status.paintImmediately(0, 0, n2, n3);
        }
        if (debug_level > n) {
            LogWriter.writeLog(string);
        }
    }

    public static final Component getStatusObject() {
        return status;
    }

    public static final void setProgress(int n) {
        if (progress_size < n) {
            progress_size = n;
        }
        if (use_client) {
            status.setValue(progress_size);
        }
    }

    public static final void resetStatus(String string) {
        progress_size = 0;
        StatusBar.updateStatus(string, 4);
    }

    public static final void setClientDisplay() {
        use_client = true;
    }
}

