/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static boolean debug = false;
    public static String log_name = null;
    private static int debug_level = 0;
    private static final int log_lines = 40;
    private static JLabel[] last_log_lines = new JLabel[40];
    private static boolean echo_to_screen = false;
    private static boolean use_client = false;
    private static boolean verbose = false;
    private static JPanel log_panel = null;

    public static final void resetLogFile() {
        block2: {
            if (log_name == null) break block2;
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(log_name, false));
                printWriter.println(TimeNow.getTimeNow() + " Running Storypad personal");
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final void writeLog(String string) {
        if (verbose) {
            System.out.println(string);
        }
        if (log_name != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(log_name, true));
                printWriter.println(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
            }
            printWriter = null;
            if (echo_to_screen && use_client) {
                int n = 1;
                while (n < 40) {
                    LogWriter.last_log_lines[n - 1] = last_log_lines[n];
                    ++n;
                }
                if (string.length() > 30) {
                    string = string.substring(0, 29);
                }
                LogWriter.last_log_lines[39] = new JLabel(string);
                log_panel.removeAll();
                int n2 = 0;
                while (n2 < 40) {
                    if (last_log_lines[n2] != null) {
                        log_panel.add(last_log_lines[n2]);
                    }
                    ++n2;
                }
                log_panel.validate();
            }
        }
    }

    public static final JScrollPane showLog() {
        log_panel = new JPanel();
        log_panel.setBackground(Color.white);
        log_panel.setLayout(new BoxLayout(log_panel, 1));
        int n = 0;
        while (n < 40) {
            if (last_log_lines[n] != null) {
                log_panel.add(last_log_lines[n]);
            }
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(log_panel);
        return jScrollPane;
    }

    public static final void debugFile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter("D://debug.txt", true));
            printWriter.println(string);
            printWriter.flush();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
        }
        printWriter = null;
    }

    public static final boolean testLogFileWriteable(String string, boolean bl) {
        boolean bl2 = false;
        File file = null;
        try {
            file = new File(string);
        }
        catch (Exception exception) {
            ShowGUIMessage.showGUIMessage("Exception " + exception + " testing log. Check logdir exists.", "Problem with logfile");
            System.err.println("Exception " + exception + " testing log. Check logdir exists.");
            System.exit(1);
        }
        if (!file.exists()) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string, true));
                printWriter.println(TimeNow.getTimeNow() + " Log created");
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + file);
            }
        }
        if (file.exists() && !file.canWrite()) {
            System.err.println("Log " + string + " exists, but cannot written - Check permissions");
            bl2 = true;
        }
        return bl2;
    }

    public static final void setupLogFile(boolean bl, int n, String string, String string2, boolean bl2) {
        use_client = bl2;
        debug_level = n;
        if (debug_level > 0) {
            debug = true;
        }
        echo_to_screen = bl;
        if (string2 != null) {
            if (string2.indexOf("v") != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
            if (string2.indexOf("i") != -1) {
                verbose = true;
                LogWriter.writeLog("Software version - " + string);
                System.exit(0);
            }
        }
        LogWriter.writeLog("Software version - " + string);
        LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        LogWriter.writeLog("=======================================================");
    }

    public static final void writeLogWithoutCR(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(log_name, true));
            printWriter.print(string);
            if (verbose) {
                System.out.print(string);
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
        }
        printWriter = null;
        if (echo_to_screen && use_client) {
            int n = 1;
            while (n < 40) {
                LogWriter.last_log_lines[n - 1] = last_log_lines[n];
                ++n;
            }
            if (string.length() > 30) {
                string = string.substring(0, 29);
            }
            LogWriter.last_log_lines[39] = new JLabel(string);
            log_panel.removeAll();
            int n2 = 0;
            while (n2 < 40) {
                log_panel.add(last_log_lines[n2]);
                ++n2;
            }
            log_panel.validate();
        }
    }

    public static final void noLogging() {
        verbose = false;
        log_name = null;
    }

    public static final void writeMethod(String string) {
        long l = Runtime.getRuntime().freeMemory() / 1024L;
        long l2 = Runtime.getRuntime().totalMemory() / 1024L;
        long l3 = l2 - l;
        string = string + " MEM=" + l3 + " ( " + l2 + " - " + l + ")";
        LogWriter.writeLog(string);
    }

    public static final void writeMethod(String string, int n) {
        if (debug_level > n) {
            LogWriter.writeLog(string);
        }
    }

    public static final void write(HashMap hashMap, int n) {
        if (debug_level > n) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                LogWriter.writeLog(entry.getKey().toString() + "=" + entry.getValue().toString());
            }
        }
    }
}

