/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_String
implements Serializable {
    int max_size = 25;
    int increment_size = 25;
    int current_item = 0;
    private String[] items = new String[this.max_size];

    public Vector_String(int n) {
        this.max_size = n;
        this.items = new String[this.max_size];
    }

    public void finalize() {
        this.items = null;
    }

    public Vector_String() {
    }

    public final String[] get() {
        return this.items;
    }

    public final String elementAt(int n) {
        this.checkSize(n);
        String string = this.items[n];
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final boolean contains(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.current_item) {
            if (this.items[n].equals(string)) {
                n = this.current_item + 1;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public final void merge(int n, int n2, String string) {
        this.items[n] = this.items[n] + string + this.items[n2];
        this.items[n2] = null;
    }

    public final void clear() {
        this.items = null;
        this.items = new String[this.max_size];
        this.current_item = 0;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            int n2 = n;
            while (n2 < this.current_item - 1) {
                this.items[n2] = this.items[n2 + 1];
                ++n2;
            }
            this.items[this.current_item - 1] = "";
        } else {
            this.items[0] = "";
        }
        --this.current_item;
    }

    public final void set(String[] stringArray) {
        this.items = stringArray;
    }

    public final void addElement(String string) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = string;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(String string, int n) {
        this.checkSize(n);
        this.items[n] = string;
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size < n) {
                this.max_size = n + 2;
            }
            String[] stringArray = this.items;
            this.items = new String[this.max_size];
            System.arraycopy(stringArray, 0, this.items, 0, n2);
            if (this.increment_size < 500) {
                this.increment_size *= 2;
            }
        }
    }
}

