/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.xobjects;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.images.PdfImages;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfXObjects {
    private PdfImages current_image_data;
    private HashMap XObject_Color = new HashMap();
    private HashMap XForms = new HashMap();
    private HashMap XObject_Reference = new HashMap();
    private HashMap XObject_Values = new HashMap();
    private String current_filename = "";
    private PdfObjectReader current_pdf_file;

    public PdfXObjects(PdfObjectReader pdfObjectReader, PdfImages pdfImages) {
        this.current_pdf_file = pdfObjectReader;
        this.current_image_data = pdfImages;
    }

    public final String getFilename() {
        return this.current_filename;
    }

    public final long getXObjectPosition(String string) {
        return (Long)this.XObject_Reference.get(string);
    }

    public final HashMap getXObjectValues(String string) {
        return (HashMap)this.XObject_Values.get(string);
    }

    public final BufferedImage processImageXObject(PdfColor pdfColor, boolean bl, GraphicsState graphicsState, long l, String string, HashMap hashMap) {
        BufferedImage bufferedImage = null;
        int n = 0;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "[0 1]";
        string = this.current_filename + "-" + string;
        String string4 = (String)hashMap.get("Filter");
        String string5 = (String)hashMap.get("DecodeParms");
        String string6 = (String)hashMap.get("ColorSpace");
        int n2 = Integer.parseInt((String)hashMap.get("Width"));
        int n3 = Integer.parseInt((String)hashMap.get("Height"));
        int n4 = Integer.parseInt((String)hashMap.get("BitsPerComponent"));
        string2 = (String)hashMap.get("Decode");
        if (string2 != null) {
            string3 = string2;
        }
        if ((string2 = (String)hashMap.get("Length")) != null) {
            n = new Integer(string2);
        }
        if ((string2 = (String)hashMap.get("ImageMask")) != null) {
            bl2 = new Boolean(string2);
        }
        try {
            this.resolveXColorInformation(pdfColor, bl, string6, graphicsState);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " resolving colorspace ");
        }
        String string7 = "Processing XObject: " + string + " width=" + n2 + " Height=" + n3 + " Depth=" + n4;
        if (bl) {
            StatusBar.updateStatus(string7, 0);
        }
        try {
            this.current_pdf_file.setImageSize(n2, n3, n4);
            byte[] byArray = this.current_pdf_file.extractBinaryData(l, n, string4, string5);
            bufferedImage = this.current_image_data.processImage(byArray, string, n2, n3, n4, string4, string5, graphicsState, string3, bl2);
            byArray = null;
            System.gc();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " processing XObject");
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error + " processing XObject " + string);
            System.gc();
        }
        if (bl) {
            StatusBar.updateStatus("", 0);
        }
        return bufferedImage;
    }

    public final PdfColor getXObjectColor(String string) {
        return (PdfColor)this.XObject_Color.get(string);
    }

    public final void processXObjects(PdfColor pdfColor, boolean bl, String string) throws PdfException {
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string = Strip.stripMainBraces(string));
        if (stringTokenizer.countTokens() == 3) {
            string = this.current_pdf_file.readXObjectHeader(string);
            stringTokenizer = new StringTokenizer(string);
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            string3 = stringTokenizer.nextToken() + " " + stringTokenizer.nextToken() + " " + stringTokenizer.nextToken();
            HashMap hashMap = this.current_pdf_file.readObjectData(string3, false, false, false);
            String string4 = (String)hashMap.get("Resources");
            this.current_pdf_file.readLine(true);
            long l = this.current_pdf_file.getPointer();
            hashMap = this.current_pdf_file.resolveReferences(hashMap);
            String string5 = (String)hashMap.get("Subtype");
            if (string5 == null) continue;
            if (string5.indexOf("/Image") != -1) {
                this.XObject_Color.put(string2, pdfColor);
                this.XObject_Values.put(string2, hashMap);
                this.XObject_Reference.put(string2, new Long(l));
                continue;
            }
            if (string5.indexOf("/Form") != -1) continue;
            LogWriter.writeLog("Unable to process XObject of type " + string5);
        }
    }

    public final void storeFileName(String string) {
        int n = string.indexOf("\\");
        if (n == -1) {
            n = string.indexOf("/");
        }
        while (n != -1) {
            if ((n = (string = string.substring(n + 1)).indexOf("\\")) != -1) continue;
            n = string.indexOf("/");
        }
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        string = Strip.stripAllSpaces(string);
        this.current_filename = string.toLowerCase();
    }

    private final void resolveXColorInformation(PdfColor pdfColor, boolean bl, String string, GraphicsState graphicsState) throws PdfException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        byte[] byArray = null;
        if (string != null) {
            if (string.indexOf("/Indexed") != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " []");
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                if (string4.equals("R")) {
                    string2 = this.current_pdf_file.getValue(string2 + " " + string3 + " " + string4);
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                }
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = string4 + " " + stringTokenizer.nextToken();
                }
                try {
                    n = Integer.parseInt(string3);
                    byArray = this.current_pdf_file.getIndexedColorMap(string4, n);
                    graphicsState.setIndexedColorMap(byArray, n);
                }
                catch (Exception exception) {
                    LogWriter.writeLog(exception + " with Colormap " + string4 + "<");
                }
            } else {
                string2 = this.current_pdf_file.getValue(string);
            }
            pdfColor.setColorSpace(bl, graphicsState, string2, false, string2);
        }
        graphicsState.setIndexedColorMap(byArray, n);
    }

    private final byte[] getXForm(String string) {
        return (byte[])this.XForms.get(string);
    }

    private final void writeRawData(String string, byte[] byArray) {
        PrintWriter printWriter = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append((char)byArray[n]);
            ++n;
        }
        string = string + "-" + System.currentTimeMillis();
        try {
            printWriter = new PrintWriter(new FileWriter("D:\\" + string + ".txt", true));
            printWriter.print(stringBuffer);
            printWriter.close();
        }
        catch (Exception exception) {}
    }

    private final void processFormXObject(String string, long l, String string2, HashMap hashMap) throws PdfException {
        boolean bl = false;
        String string3 = "";
        byte[] byArray = this.current_pdf_file.readStreamObject();
        byte[] byArray2 = new byte[byArray.length];
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            dataInputStream.readFully(byArray2);
            dataInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing pdf data");
        }
        this.XForms.put(string2, byArray2);
    }
}

