/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.gui;

import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class FileOpenButtonBean
extends Button
implements Serializable,
ActionListener {
    private static final String MY_BUTTON_LABEL = "Open file...";
    private String filePath;
    private String fileDirectory;
    private String fileName;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Test FileOpenButtonBean");
        FileOpenButtonBean fileOpenButtonBean = new FileOpenButtonBean();
        frame.setLayout(new FlowLayout());
        frame.add(fileOpenButtonBean);
        ((Component)frame).setSize(250, 200);
        frame.show();
    }

    public FileOpenButtonBean() {
        super(MY_BUTTON_LABEL);
        this.addActionListener(this);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileDirectory() {
        return this.fileDirectory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog(new Frame(), "Open file");
        fileDialog.show();
        this.fileDirectory = fileDialog.getDirectory();
        this.fileName = fileDialog.getFile();
        this.filePath = String.valueOf(this.fileDirectory) + this.fileName;
        this.changes.firePropertyChange("fileDirectory", null, this.fileDirectory);
        this.changes.firePropertyChange("fileName", null, this.fileName);
        this.changes.firePropertyChange("filePath", null, this.filePath);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }
}

