/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.gui;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class ImageShowBean
extends Canvas
implements Serializable {
    private final int DEFAULT_WIDTH = 50;
    private final int DEFAULT_HEIGHT = 50;
    private String imagePath;
    private transient Image image;
    private transient int imageWidth = -1;
    private transient int imageHeight = -1;
    private boolean hasImageSize;
    private boolean doIntermediateUpdates;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Test ImageShowBean");
        ImageShowBean imageShowBean = new ImageShowBean();
        imageShowBean.setImagePath("Testimg.gif");
        frame.setLayout(new FlowLayout());
        frame.add(imageShowBean);
        ((Component)frame).setSize(250, 200);
        frame.show();
    }

    public ImageShowBean() {
        this.setSize(50, 50);
        this.doIntermediateUpdates = true;
    }

    public Image getImage() {
        return this.image;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.hasImageSize = false;
        this.imagePath = string;
        this.image = this.getToolkit().getImage(string);
        this.getToolkit().prepareImage(this.image, -1, -1, this);
        this.changes.firePropertyChange("image", null, this.image);
    }

    public boolean getDoIntermediateUpdates() {
        return this.doIntermediateUpdates;
    }

    public void setDoIntermediateUpdates(boolean bl) {
        this.doIntermediateUpdates = bl;
    }

    public void paint(Graphics graphics) {
        if (this.image != null && this.imageWidth == -1) {
            this.imageWidth = this.image.getWidth(this);
        }
        if (this.image != null && this.imageHeight == -1) {
            this.imageHeight = this.image.getHeight(this);
        }
        if (this.image == null || this.imageWidth == -1 || this.imageHeight == -1) {
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, 0);
            return;
        }
        if (!this.hasImageSize) {
            this.setSize(this.imageWidth, this.imageHeight);
            this.hasImageSize = true;
            this.getParent().doLayout();
        }
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }
}

