/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.ImageSaverInterface;
import fi.faidon.util.DataCompression;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class PICTImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static final String FORMAT_CODE = "PICT";
    public static final String FORMAT_COMPLETE_NAME = "Macintosh PICT";
    public static final String FORMAT_EXTENSION = "pct";
    private final int SRC_COPY = 0;
    private final int PICT_NULL_HEADER_SIZE = 512;
    private final int IMAGE_RESOLUTION = 72;
    private final int NBR_BYTES_IN_WORD = 2;
    private final int NBR_BYTES_IN_LONG = 4;
    private final int OP_CLIP_RGN = 1;
    private final int OP_VERSION = 17;
    private final int OP_DEF_HILITE = 30;
    private final int OP_V2_HEADER_OP = 3072;
    private final int OP_DIRECT_BITS_RECT = 154;
    private final int OP_END_OF_PICTURE = 255;
    private final int OP_VERSION_2 = 767;
    private final int EXT_VERSION_2_CODE = 65534;
    private FileOutputStream writeFileHandle;
    private int width;
    private int height;
    private int rowBytes;
    private int saveStatus;
    private int byteCount;
    private byte[] scanlineBytes;
    private byte[] packedScanlineBytes;
    private int scanWidthLeft;

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        this.saveStatus = 0;
        try {
            this.writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred opening FileOutputStream : " + iOException);
        }
        if (this.writeFileHandle == null) {
            return false;
        }
        ImageProducer imageProducer = this.saveImage.getSource();
        if (imageProducer == null) {
            return false;
        }
        imageProducer.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public void setProperties(Hashtable hashtable) {
        this.saveStatus |= 4;
    }

    public void setHints(int n) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[4];
        this.width = n;
        this.height = n2;
        this.byteCount = 0;
        byte[] byArray4 = new byte[512];
        byArray4[0] = 80;
        byArray4[1] = 73;
        byArray4[2] = 67;
        byArray4[3] = 84;
        try {
            this.writeFileHandle.write(byArray4);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray4.length;
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = 0;
            ++n3;
        }
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(0, byArray2, 2, 4);
        this.setIntAsBytes(0, byArray2, 0, 2);
        this.setIntAsBytes(n, byArray2, 6, 8);
        this.setIntAsBytes(n2, byArray2, 4, 6);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        this.setIntAsBytes(17, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(767, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(3072, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(65534, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(72, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(72, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += 4 * byArray.length;
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        this.setIntAsBytes(0, byArray3, 0, byArray3.length);
        try {
            this.writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray3.length;
        this.setIntAsBytes(30, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(1, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(10, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += 2 * byArray.length;
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        this.setIntAsBytes(154, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(255, byArray3, 0, byArray3.length);
        try {
            this.writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray3.length;
        this.rowBytes = 4 * n;
        this.setIntAsBytes(this.rowBytes, byArray, 0, byArray.length);
        byArray[0] = (byte)(byArray[0] | 0x80);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray2.length;
        this.setIntAsBytes(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(4, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(0, byArray3, 0, byArray3.length);
        try {
            this.writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray3.length;
        this.setIntAsBytes(72, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(72, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += 4 * byArray.length;
        this.setIntAsBytes(16, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(32, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(3, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(8, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.setIntAsBytes(0, byArray3, 0, byArray3.length);
        try {
            this.writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray3.length;
        this.setIntAsBytes(0, byArray3, 0, byArray3.length);
        try {
            this.writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray3.length;
        this.setIntAsBytes(0, byArray3, 0, byArray3.length);
        try {
            this.writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray3.length;
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += 2 * byArray2.length;
        this.setIntAsBytes(0, byArray, 0, byArray.length);
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.byteCount += byArray.length;
        this.scanlineBytes = new byte[3 * this.width];
        this.packedScanlineBytes = new byte[DataCompression.getPackBitsMaxDestBytes(this.scanlineBytes.length)];
        this.scanWidthLeft = this.width;
        this.saveStatus |= 3;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[2];
        int n7 = 0;
        while (n7 < n4) {
            this.scanWidthLeft -= n3;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = colorModel.getRGB(byArray[n5 + n7 * n6 + n8] & 0xFF);
                this.scanlineBytes[n + n8] = (byte)(n9 >> 16 & 0xFF);
                this.scanlineBytes[n + this.width + n8] = (byte)(n9 >> 8 & 0xFF);
                this.scanlineBytes[n + 2 * this.width + n8] = (byte)(n9 & 0xFF);
                ++n8;
            }
            if (this.scanWidthLeft == 0) {
                int n10 = DataCompression.packBits(this.scanlineBytes, this.packedScanlineBytes, this.scanlineBytes.length);
                if (this.rowBytes > 250) {
                    this.setIntAsBytes(n10, byArray3, 0, byArray3.length);
                    try {
                        this.writeFileHandle.write(byArray3);
                    }
                    catch (IOException iOException) {
                        this.saveStatus = 64;
                    }
                    this.byteCount += byArray3.length;
                } else {
                    this.setIntAsBytes(n10, byArray2, 0, byArray2.length);
                    try {
                        this.writeFileHandle.write(byArray2);
                    }
                    catch (IOException iOException) {
                        this.saveStatus = 64;
                    }
                    this.byteCount += byArray2.length;
                }
                try {
                    this.writeFileHandle.write(this.packedScanlineBytes, 0, n10);
                }
                catch (IOException iOException) {
                    this.saveStatus = 64;
                }
                this.byteCount += n10;
                this.scanWidthLeft = this.width;
            }
            ++n7;
        }
        this.saveStatus |= 8;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        int n7 = 0;
        while (n7 < n4) {
            this.scanWidthLeft -= n3;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = colorModel.getRGB(nArray[n5 + n7 * n6 + n8]);
                this.scanlineBytes[n + n8] = (byte)(n9 >> 16 & 0xFF);
                this.scanlineBytes[n + this.width + n8] = (byte)(n9 >> 8 & 0xFF);
                this.scanlineBytes[n + 2 * this.width + n8] = (byte)(n9 & 0xFF);
                ++n8;
            }
            if (this.scanWidthLeft == 0) {
                int n10 = DataCompression.packBits(this.scanlineBytes, this.packedScanlineBytes, this.scanlineBytes.length);
                if (this.rowBytes > 250) {
                    this.setIntAsBytes(n10, byArray2, 0, byArray2.length);
                    try {
                        this.writeFileHandle.write(byArray2);
                    }
                    catch (IOException iOException) {
                        this.saveStatus = 64;
                    }
                    this.byteCount += byArray2.length;
                } else {
                    this.setIntAsBytes(n10, byArray, 0, byArray.length);
                    try {
                        this.writeFileHandle.write(byArray);
                    }
                    catch (IOException iOException) {
                        this.saveStatus = 64;
                    }
                    this.byteCount += byArray.length;
                }
                try {
                    this.writeFileHandle.write(this.packedScanlineBytes, 0, n10);
                }
                catch (IOException iOException) {
                    this.saveStatus = 64;
                }
                this.byteCount += n10;
                this.scanWidthLeft = this.width;
            }
            ++n7;
        }
        this.saveStatus |= 8;
    }

    public void imageComplete(int n) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        if ((this.byteCount & 1) > 0) {
            byArray[0] = 0;
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.setIntAsBytes(255, byArray2, 0, 2);
        try {
            this.writeFileHandle.write(byArray2);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.close();
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 0x20;
    }

    private void setIntAsBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 1;
        int n5 = 0;
        while (n4 >= n2) {
            byArray[n4] = (byte)(n >> n5 & 0xFF);
            --n4;
            n5 += 8;
        }
    }
}

