/*
 * Decompiled with CFR 0.152.
 */
package fi.faidon.jis;

import fi.faidon.jis.ImageSaverInterface;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class TIFFImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static final String FORMAT_CODE = "TIFF";
    public static final String FORMAT_COMPLETE_NAME = "TIFF";
    public static final String FORMAT_EXTENSION = "tif";
    private final int HEADER_SIZE = 8;
    private final int IFD_FIELD_SIZE = 12;
    private final int OFFSET_BYTE_SIZE = 4;
    private final int NEXT_IFD_OFFSET_SIZE = 4;
    private final int BITS_PER_SAMPLE_SIZE = 6;
    private final int RESOLUTION_DATA_SIZE = 8;
    private final int BYTES_PER_PIXEL = 3;
    private final int NBR_BITS_IN_BYTE = 8;
    private FileOutputStream writeFileHandle;
    private int saveStatus;

    public String getFormatCode() {
        return "TIFF";
    }

    public String getFormatString() {
        return "TIFF";
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        this.saveStatus = 0;
        try {
            this.writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred opening FileOutputStream : " + iOException);
        }
        if (this.writeFileHandle == null) {
            return false;
        }
        ImageProducer imageProducer = this.saveImage.getSource();
        if (imageProducer == null) {
            return false;
        }
        imageProducer.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public void setProperties(Hashtable hashtable) {
        this.saveStatus |= 4;
    }

    public void setHints(int n) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
        int n3 = 13;
        int n4 = 10 + n3 * 12 + 4;
        int n5 = n4 + 6;
        int n6 = n5 + 8;
        int n7 = n6 + 8;
        int n8 = 2;
        while (n8 * n * 3 <= 8192) {
            ++n8;
        }
        int n9 = (n2 + --n8 - 1) / n8;
        int n10 = n8 * n * 3;
        int n11 = n7 + n9 * 4;
        int n12 = n11 + n9 * 4;
        byte[] byArray = new byte[]{77, 77, 0, 42, 0, 0, 0, 8, 0, (byte)n3};
        try {
            this.writeFileHandle.write(byArray);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray2 = new byte[12];
        byArray2[1] = -2;
        byArray2[3] = 4;
        byArray2[7] = 1;
        byte[] byArray3 = byArray2;
        try {
            this.writeFileHandle.write(byArray3);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray4 = new byte[12];
        byArray4[0] = 1;
        byArray4[3] = 4;
        byArray4[7] = 1;
        byArray4[10] = (byte)(n >> 8 & 0xFF);
        byArray4[11] = (byte)(n & 0xFF);
        byte[] byArray5 = byArray4;
        try {
            this.writeFileHandle.write(byArray5);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray6 = new byte[12];
        byArray6[0] = 1;
        byArray6[1] = 1;
        byArray6[3] = 4;
        byArray6[7] = 1;
        byArray6[10] = (byte)(n2 >> 8 & 0xFF);
        byArray6[11] = (byte)(n2 & 0xFF);
        byte[] byArray7 = byArray6;
        try {
            this.writeFileHandle.write(byArray7);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray8 = new byte[12];
        byArray8[0] = 1;
        byArray8[1] = 2;
        byArray8[3] = 3;
        byArray8[7] = 3;
        byArray8[10] = (byte)(n4 >> 8 & 0xFF);
        byArray8[11] = (byte)(n4 & 0xFF);
        byte[] byArray9 = byArray8;
        try {
            this.writeFileHandle.write(byArray9);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray10 = new byte[12];
        byArray10[0] = 1;
        byArray10[1] = 3;
        byArray10[3] = 3;
        byArray10[7] = 1;
        byArray10[9] = 1;
        byte[] byArray11 = byArray10;
        try {
            this.writeFileHandle.write(byArray11);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray12 = new byte[12];
        byArray12[0] = 1;
        byArray12[1] = 6;
        byArray12[3] = 3;
        byArray12[7] = 1;
        byArray12[9] = 2;
        byte[] byArray13 = byArray12;
        try {
            this.writeFileHandle.write(byArray13);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray14 = new byte[12];
        byArray14[0] = 1;
        byArray14[1] = 17;
        byArray14[3] = 4;
        byArray14[4] = (byte)(n9 >> 24 & 0xFF);
        byArray14[5] = (byte)(n9 >> 16 & 0xFF);
        byArray14[6] = (byte)(n9 >> 8 & 0xFF);
        byArray14[7] = (byte)(n9 & 0xFF);
        byArray14[10] = (byte)(n7 >> 8 & 0xFF);
        byArray14[11] = (byte)(n7 & 0xFF);
        byte[] byArray15 = byArray14;
        try {
            this.writeFileHandle.write(byArray15);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray16 = new byte[12];
        byArray16[0] = 1;
        byArray16[1] = 21;
        byArray16[3] = 3;
        byArray16[7] = 1;
        byArray16[9] = 3;
        byte[] byArray17 = byArray16;
        try {
            this.writeFileHandle.write(byArray17);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray18 = new byte[12];
        byArray18[0] = 1;
        byArray18[1] = 22;
        byArray18[3] = 4;
        byArray18[7] = 1;
        byArray18[8] = (byte)(n8 >> 24 & 0xFF);
        byArray18[9] = (byte)(n8 >> 16 & 0xFF);
        byArray18[10] = (byte)(n8 >> 8 & 0xFF);
        byArray18[11] = (byte)(n8 & 0xFF);
        byte[] byArray19 = byArray18;
        try {
            this.writeFileHandle.write(byArray19);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray20 = new byte[12];
        byArray20[0] = 1;
        byArray20[1] = 23;
        byArray20[3] = 4;
        byArray20[4] = (byte)(n9 >> 24 & 0xFF);
        byArray20[5] = (byte)(n9 >> 16 & 0xFF);
        byArray20[6] = (byte)(n9 >> 8 & 0xFF);
        byArray20[7] = (byte)(n9 & 0xFF);
        byArray20[10] = (byte)(n11 >> 8 & 0xFF);
        byArray20[11] = (byte)(n11 & 0xFF);
        byte[] byArray21 = byArray20;
        try {
            this.writeFileHandle.write(byArray21);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray22 = new byte[12];
        byArray22[0] = 1;
        byArray22[1] = 26;
        byArray22[3] = 5;
        byArray22[7] = 1;
        byArray22[10] = (byte)(n5 >> 8 & 0xFF);
        byArray22[11] = (byte)(n5 & 0xFF);
        byte[] byArray23 = byArray22;
        try {
            this.writeFileHandle.write(byArray23);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray24 = new byte[12];
        byArray24[0] = 1;
        byArray24[1] = 27;
        byArray24[3] = 5;
        byArray24[7] = 1;
        byArray24[10] = (byte)(n6 >> 8 & 0xFF);
        byArray24[11] = (byte)(n6 & 0xFF);
        byte[] byArray25 = byArray24;
        try {
            this.writeFileHandle.write(byArray25);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray26 = new byte[12];
        byArray26[0] = 1;
        byArray26[1] = 40;
        byArray26[3] = 3;
        byArray26[7] = 1;
        byArray26[9] = 1;
        byte[] byArray27 = byArray26;
        try {
            this.writeFileHandle.write(byArray27);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray28 = new byte[4];
        try {
            this.writeFileHandle.write(byArray28);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray29 = new byte[6];
        byArray29[1] = 8;
        byArray29[3] = 8;
        byArray29[5] = 8;
        byte[] byArray30 = byArray29;
        try {
            this.writeFileHandle.write(byArray30);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray31 = new byte[8];
        byArray31[2] = 1;
        byArray31[3] = 44;
        byArray31[7] = 1;
        byte[] byArray32 = byArray31;
        try {
            this.writeFileHandle.write(byArray32);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        try {
            this.writeFileHandle.write(byArray32);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        byte[] byArray33 = new byte[4];
        int n13 = 0;
        int n14 = n12;
        while (n13 < n9) {
            byArray33[0] = (byte)(n14 >> 24 & 0xFF);
            byArray33[1] = (byte)(n14 >> 16 & 0xFF);
            byArray33[2] = (byte)(n14 >> 8 & 0xFF);
            byArray33[3] = (byte)(n14 & 0xFF);
            try {
                this.writeFileHandle.write(byArray33);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            ++n13;
            n14 += n10;
        }
        byArray33[0] = (byte)(n10 >> 24 & 0xFF);
        byArray33[1] = (byte)(n10 >> 16 & 0xFF);
        byArray33[2] = (byte)(n10 >> 8 & 0xFF);
        byArray33[3] = (byte)(n10 & 0xFF);
        n13 = 0;
        while (n13 < n9 - 1) {
            try {
                this.writeFileHandle.write(byArray33);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
            ++n13;
        }
        int n15 = (n2 - (n9 - 1) * n8) * n * 3;
        byArray33[0] = (byte)(n15 >> 24 & 0xFF);
        byArray33[1] = (byte)(n15 >> 16 & 0xFF);
        byArray33[2] = (byte)(n15 >> 8 & 0xFF);
        byArray33[3] = (byte)(n15 & 0xFF);
        try {
            this.writeFileHandle.write(byArray33);
        }
        catch (IOException iOException) {
            this.saveStatus = 64;
        }
        this.saveStatus |= 3;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        byte[] byArray2 = new byte[n3 * n4 * 3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = colorModel.getRGB(byArray[n5 + n7 * n6 + n8] & 0xFF);
                int n10 = (n7 * n3 + n8) * 3 + 3 - 1;
                int n11 = 0;
                while (n11 < 3) {
                    byArray2[n10 - n11] = (byte)(n9 >> n11 * 8 & 0xFF);
                    ++n11;
                }
                ++n8;
            }
            ++n7;
        }
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.write(byArray2);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 8;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        byte[] byArray = new byte[n3 * n4 * 3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = colorModel.getRGB(nArray[n5 + n7 * n6 + n8]);
                int n10 = (n7 * n3 + n8) * 3 + 3 - 1;
                int n11 = 0;
                while (n11 < 3) {
                    byArray[n10 - n11] = (byte)(n9 >> n11 * 8 & 0xFF);
                    ++n11;
                }
                ++n8;
            }
            ++n7;
        }
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.write(byArray);
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 8;
    }

    public void imageComplete(int n) {
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.close();
            }
            catch (IOException iOException) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 0x20;
    }
}

