/*
Copyright (C) 1999/2000 Hendrik Lipka.
All rights reserved.

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along with this
program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA or see http://www.gnu.org

If you encounter problems or have a suggestion, please mail to:
hli@hendriklipka.de
*/
package de.hendriklipka.pdfconv;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class HTMLWriter extends DocumentWriter
{
    public HTMLWriter ()
    {
       super();
    }

    public void open(String fileName) throws IOException
    {
        _writer=new PrintWriter(new FileWriter(fileName+"_index.html"));
    }


    public void writeHeader(String targetBaseName)
    {
        if (null!=_writer)
            _writer.println("<html>\n<head>\n<title>"+targetBaseName +"</title>\n</head>\n<body>");
    }

    public void writeFooter()
    {
        if (null!=_writer)
            _writer.println("</body>\n</html>");
    }

    public void writeLine(String targetName)
    {
        if (null!=_writer)
            _writer.println("<IMG SRC=\""+targetName+"\" ALT=\""+targetName+"\" BORDER=\"0\"><br>");
    }

    public void close()
    {
        if (null!=_writer)
            _writer.close();
    }
}
