package de.hendriklipka.pdfconv;

import org.jpedal.PdfDecoder;

import java.awt.image.*;
import java.awt.geom.AffineTransform;
import java.awt.*;
import java.awt.color.ColorSpace;

public abstract class ImageWriter
{
    protected double _maxHeigth=-1;
    protected double _maxWidth=-1;
    protected double _scaleFactor=1;
    protected float _quality=0.85f;

    public void setQuality(String quality)
    {
        try
        {
            _quality=Float.parseFloat(quality);
        }
        catch (NumberFormatException e)
        {
        }
    }

    public void setScaleFactor(String scaleFactor)
    {
        try
        {
            _scaleFactor=Double.parseDouble(scaleFactor);
        }
        catch (NumberFormatException e)
        {
        }
    }

    public void setMaxHeigth(String maxHeigth)
    {
        try
        {
            _maxHeigth=Integer.parseInt(maxHeigth);
        }
        catch (NumberFormatException e)
        {
        }
    }

    public void setMaxWidht(String maxWidth)
    {
        try
        {
            _maxWidth=Integer.parseInt(maxWidth);
        }
        catch (NumberFormatException e)
        {
        }
    }

    public void writeImage(BufferedImage targetImage, String targetDir, String targetName)
    {
//        System.out.println("image: width="+targetImage.getWidth()+", heigth="+targetImage.getHeight());
        double heigth=targetImage.getHeight();
        double width=targetImage.getWidth();
        boolean flipImage=false;
        AffineTransform at=new AffineTransform();

        String version=PdfDecoder.version;
        double d=Double.parseDouble(version);
        if (d>1.81) // flipping the image is needed since jpedal version 1.81
        {
            System.out.println("flipping image");
            flipImage=true;
            at.scale(1, -1); // flip image upside-down
            at.translate(0, -targetImage.getHeight());
        }
        boolean scaleImage=false;
        double scaleFactor=_scaleFactor;
        if (-1!=_maxHeigth||-1!=_maxWidth||1!=_scaleFactor)
        {
//            System.out.println("checking for scale");
            if (-1!=_maxWidth&&_maxWidth<width)
            {
                d=_maxWidth/width;
                if (d<scaleFactor)
                    scaleFactor=d;
                scaleImage=true;
//                System.out.println("scale width="+scaleFactor);
            }
            if (-1!=_maxHeigth&&_maxHeigth<heigth)
            {
                d=_maxHeigth/heigth;
//                System.out.println("scale heigth="+d);
                if (d<scaleFactor)
                    scaleFactor=d;
                scaleImage=true;
            }
            if (1!=_scaleFactor)
                scaleImage=true;
//            System.out.println("scale factor="+scaleFactor);
            at.scale(scaleFactor, scaleFactor);
        }
        if (flipImage||scaleImage)
        {
//            System.out.println("doing transformation");
            AffineTransformOp ato=new AffineTransformOp(at, null);
            targetImage=ato.filter(targetImage, null);
        }
        System.out.println("color conversion");
        System.out.println(targetImage.getColorModel().toString());
//        ColorSpace cs=ColorSpace.getInstance(ColorSpace.CS_sRGB);
//        ColorConvertOp cco=new ColorConvertOp(cs,null);
//        targetImage=cco.filter(targetImage,null);
//        System.out.println("image: width="+targetImage.getWidth()+", heigth="+targetImage.getHeight());
//        System.out.println(targetImage.getColorModel().toString());
//        ColorModel cm=targetImage.getColorModel();
//        if (cm instanceof IndexColorModel)
//            System.out.println("index color model");
        System.out.println("saving");
        saveImage(targetDir+targetName, targetImage);
    }

    protected abstract boolean saveImage(String current_image, BufferedImage image);
}
