/*
Copyright (C) 1999/2000 Hendrik Lipka.
All rights reserved.

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along with this
program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA or see http://www.gnu.org

If you encounter problems or have a suggestion, please mail to:
hli@hendriklipka.de
*/
package de.hendriklipka.pdfconv;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class JPEGImageWriter extends ImageWriter
{
    protected boolean saveImage(String current_image, BufferedImage image)
    {
        String file_name = current_image;
        try
        {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(file_name)));
            JPEGEncodeParam param = JPEGCodec.getDefaultJPEGEncodeParam(image);
            param.setQuality(_quality, true);
            JPEGImageEncoder as_jpeg = JPEGCodec.createJPEGEncoder(out, param);
            as_jpeg.encode(image);
            out.close();
        }
        catch (Exception e)
        {
        }
        return true;
    }

}
