package de.hendriklipka.pdfconv;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.color.ColorSpace;
import java.io.FileOutputStream;

import java.io.*;
import java.awt.*;
import fi.faidon.jis.*;
import java.awt.image.ImageObserver;

public class PICTImageWriter extends ImageWriter
{
    public PICTImageWriter()
    {
        super();
    }

    protected boolean saveImage(String current_image, BufferedImage image)
    {
        try
        {
        	/*
            FileOutputStream fos=new FileOutputStream(current_image);
            PICTEncoderFactory pef=new PICTEncoderFactory();
            JimiEncoder enc=pef.createEncoder();
            enc.encodeImages(new JimiImageEnumeration(image), fos);
            fos.close();
            */

    		PICTImageSaver	is;
    		is = new PICTImageSaver();
    		is.setSaveImage(image);
    		is.setSavePath(current_image);
    		is.saveIt();

    		// Wait until saving is ready.
    		while ( (is.checkSave() & ( ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR )) == 0 ) {
    			System.out.println("Waiting for save to finish!");
    			try { Thread.sleep(100); }
    			catch ( InterruptedException e ) { System.exit(1); }
    		}

            return true;
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        return false;
    }
}
