#############################################################################
#
#              GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/ByteCodes.py,v $
# Version:     $RCSfile: ByteCodes.py,v $ $Revision: 1.2 $
# Copyright:   (C) 1997-1999, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

the virtual machine bytecode definitions

"""

#############################################################################
# byte_count, operand_count, do_shift, mask, byte1, byte2, byte3, name
#

inst_table = [
# simple instructions  (A = 0)
(1,1,0, 0xFF,0x00,0x00,0x00,"pop"),
(1,1,0, 0xFF,0x01,0x00,0x00,"dup"),
(1,1,0, 0xFF,0x02,0x00,0x00,"return"),
(1,1,0, 0xFF,0x03,0x00,0x00,"push_self"),
(1,1,0, 0xFF,0x04,0x00,0x00,"set_lex_scope"),
(1,1,0, 0xFF,0x05,0x00,0x00,"iter_next"),
(1,1,0, 0xFF,0x06,0x00,0x00,"iter_done"),
(3,3,0, 0xFF,0x07,0x00,0x07,"pop_handlers"),    # nb. always 3 bytes

# parameterised instructions
(1,1,0, 0xF8,0x18,0x00,0x00,"push"),
(1,1,1, 0xF8,0x20,0x00,0x00,"push_constant"),
(1,1,0, 0xF8,0x28,0x00,0x00,"call"),
(1,1,0, 0xF8,0x30,0x00,0x00,"invoke"),
(1,1,0, 0xF8,0x38,0x00,0x00,"send"),
(1,1,0, 0xF8,0x40,0x00,0x00,"send_if_defined"),
(1,1,0, 0xF8,0x48,0x00,0x00,"resend"),
(1,1,0, 0xF8,0x50,0x00,0x00,"resend_if_defined"),
(1,3,0, 0xF8,0x58,0x00,0x00,"branch"),
(1,3,0, 0xF8,0x60,0x00,0x00,"branch_if_true"),
(1,3,0, 0xF8,0x68,0x00,0x00,"branch_if_false"),
(1,1,0, 0xF8,0x70,0x00,0x00,"find_var"),
(1,1,0, 0xF8,0x78,0x00,0x00,"get_var"),
(1,1,0, 0xF8,0x80,0x00,0x00,"make_frame"),
(1,1,0, 0xF8,0x88,0x00,0x00,"make_array"),
(1,1,0, 0xF8,0x90,0x00,0x00,"get_path"),
(1,1,0, 0xF8,0x98,0x00,0x00,"set_path"),
(1,1,0, 0xF8,0xA0,0x00,0x00,"set_var"),
(1,1,0, 0xF8,0xA8,0x00,0x00,"find_and_set_var"),
(1,1,0, 0xF8,0xB0,0x00,0x00,"incr_var"),
(1,1,0, 0xF8,0xB8,0x00,0x00,"branch_if_loop_not_done"),
# freq-func (A = 24) not implemented since VM does primitives internally
(1,1,0, 0xF8,0xC8,0x00,0x00,"new_handlers"),

# primitive functions
(1,1,0, 0xFF,0xC0,0x00,0x00,"add"),
(1,1,0, 0xFF,0xC1,0x00,0x00,"subtract"),
(1,1,0, 0xFF,0xC2,0x00,0x00,"aref"),
(1,1,0, 0xFF,0xC3,0x00,0x00,"set_aref"),
(1,1,0, 0xFF,0xC4,0x00,0x00,"equals"),
(1,1,0, 0xFF,0xC5,0x00,0x00,"not"),
(1,1,0, 0xFF,0xC6,0x00,0x00,"not_equals"),

(3,3,0, 0xFF,0xC7,0x00,0x07,"multiply"),
(3,3,0, 0xFF,0xC7,0x00,0x08,"divide"),
(3,3,0, 0xFF,0xC7,0x00,0x09,"div"),
(3,3,0, 0xFF,0xC7,0x00,0x0A,"less_than"),
(3,3,0, 0xFF,0xC7,0x00,0x0B,"greater_than"),
(3,3,0, 0xFF,0xC7,0x00,0x0C,"greater_or_equal"),
(3,3,0, 0xFF,0xC7,0x00,0x0D,"less_or_equal"),
(3,3,0, 0xFF,0xC7,0x00,0x0E,"bit_and"),
(3,3,0, 0xFF,0xC7,0x00,0x0F,"bit_or"),
(3,3,0, 0xFF,0xC7,0x00,0x10,"bit_not"),
(3,3,0, 0xFF,0xC7,0x00,0x11,"new_iterator"),
(3,3,0, 0xFF,0xC7,0x00,0x12,"length"),
(3,3,0, 0xFF,0xC7,0x00,0x13,"clone"),
(3,3,0, 0xFF,0xC7,0x00,0x14,"set_class"),
(3,3,0, 0xFF,0xC7,0x00,0x15,"add_array_slot"),
(3,3,0, 0xFF,0xC7,0x00,0x16,"stringer"),
(3,3,0, 0xFF,0xC7,0x00,0x17,"has_path"),
(3,3,0, 0xFF,0xC7,0x00,0x18,"class_of"),
]

#############################################################################
