#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/DisplayDevice.py,v $
# Version:     $RCSfile: DisplayDevice.py,v $ $Revision: 1.1.1.1 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

from   GnutOS.DeviceDriver             import DeviceDriver
from   GnutOS.Device                   import Device


#############################################################################

class DisplayDriver(DeviceDriver):
    """

    Driver code for hardware devices.

    """

    def __init__(self, hwMgr):
	self._mgr = hwMgr

    def DeviceType(self):
	"""Return an identifier for the device type."""
	return None   # this is an abstract class

    def Name(self):
	"""Return the unique signature for this driver."""
	return None   # this is an abstract class

    def ParentType(self):
	return self._driver.type()

    def IsShareable(self):
	return self._driver.shareable()

    def NewDevice(self, t_param):
	"""Create a device instance."""
	return Device(self, t_param)


#############################################################################

class DisplayDevice(Device):
    def __init__(self, driver, params):
	self._driver = driver

    def DeviceType(self):
	return self._driver.type()

    def ParentType(self):
	return self._driver.parent()

    def IsShareable(self):
	return self._driver.shareable()

    def Reserve(self):
	pass

    def Release(self, uid):
	pass


    #
    #   primitive graphical view classes
    #

    def plView(self, template):
	pass

    def plPictureView(self, template):
	pass

    def plEditView(self, template):
	pass

    def plParagraphView(self, template):
	pass

    def plPolygonView(self, template):
	pass

    def plKeyboardView(self, template):
	pass

    def plMonthView(self, template):
	pass

    def plRemoteView(self, template):
	pass

    def plPickView(self, template):
	pass

    def plGaugeView(self, template):
	pass

    def plOutline(self, template):
	pass


    #
    #   drawing methods for display devices
    #

    def DrawPixel(colour, x, y):
	"""Draw pixel at specified coordinates, in specified colour."""

	pass


    def DrawLine(colour, width, style, capStyle, *args):
	"""Draw a line joining the specified points."""

	pass


    def DrawRect(colour, borderWidth, borderColour, x1, y1, x2, y2):
	pass


    def DrawRoundRect(colour, borderWidth, borderColour, x1, y1, x2, y2):
	pass


    def DrawArc(colour, borderWidth, borderColour, extent, xc, yc, x1, y1):
	pass


    def DrawPixmap(pixMap, x, y):
	pass



#############################################################################
#############################################################################

