#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/EntryCache.py,v $
# Version:     $RCSfile: EntryCache.py,v $ $Revision: 1.1.1.1 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

class EntryCache:
    """

    GNUton system RAM contains space used to cache Soup entries as
    they are read from Cursors as the result of a soup query.  Soups
    are never (or are at least unlikely to ever be) entirely resident
    in the system memory, but instead are read from the storage
    memory, possibly decompressed, and kept in the Entry Cache until
    flushed back to the storage domain when no longer needed.

    This also makes it possible for modified entries to be discarded
    without flushing changes back to the Soup in the storage domain,
    effectively rolling-back any changes made.

    A GNUton instance may have only one EntryCache and it is closely
    associated with the StorageManager.

    """

    def __init__(self, ref_gnut):
	""" """

	self._gnut = ref_gnut
	return


    def FlushStoreEntries(self, refStore):
	"""Remove entries from the specified Store from the cache.

	*refStore*
	Returns

	When is Store is unmounted, its Soup Entries are no longer
	available to the system, and can be flushed from the
	EntryCache.  This method performs this removal for Entries
	from a specified Store's Soups."""

	return


#############################################################################

