#! /usr/bin/env python
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/Globals.py,v $
# Version:     $RCSfile: Globals.py,v $ $Revision: 1.1.1.1 $
# Copyright:   (C) 1997-1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""
Globals

Implementations of the NewtonScript globals functions.

"""

#############################################################################
#
#  these functions require a global reference to the GNUton device, which
#  must be initialised during booting.

gnut = None


#############################################################################
#  object system functions

def ClassOf(object):
    return object._class

def Clone(object):
    pass

def DeepClone(object):
    pass

def GetVariable(frame, slotSymbol):
    pass

def IsArray(obj):
    pass

def IsBinary(obj):
    pass

def IsFrame(obj):
    pass

def IsImmediate(obj):
    pass

def IsInstance(obj, klass):
    pass

def Map(obj, function):
    pass

def PrimClassOf(obj):
    return self._primitive

def RemoveSlot(object, slot):
    pass

def ReplaceObject(orginalObject, targetObject):
    pass

def SetClass(object, classSymbol):
    pass

def TotalClone(object):
    pass


def IsSubclass(self, klass):
    pass


#############################################################################
#  frame accessors

def HasSlot(frame, name):
    """Return True if frame has named slot, else NIL """
    pass


def GetSlot(frame, name):
    """Return the value of the named slot, else NIL"""
    pass


def SetSlot(frame, name, value):
    """ """
    pass


#############################################################################
#  store functions


def GetStores():
    """Return an array of references to all existing stores."""

    global gnut

    return gnut.StorageManager().ListStores()


def SetDefaultStore(newDefaultStore):
    """Sets the default store and returns reference to it."""

    global gnut

    gnut.SetDefaultStore(newDefaultStore)
    return



    
#############################################################################
#  soup functions

def CreateSoupFromSoupDef(soupDef, store, changeSym):
    return

def GetUnionSoupAlways(soupNameString):
    return

def IsSoupEntry(object):
    """Returns True if object is a soup entry."""
    return NIL

def RegSoupChange(soupName, callbackID, callBackFn):
    return

def RegUnionSoup(appSymbol, soupDef):
    return

def UnRegSoupChange(soupName, callbackID):
    return

def UnRegUnionSoup(name, appSymbol):
    return

def XmitSoupChange(soupName, appSymbol, changeType, changeData):
    return


#-- obsolete functions

def BroadcastSoupChange(soupNameString):
    raise ObsoleteFunction("use Xmit methods or XmitSoupChange().")

def GetUnionSoup(soupNameString):
    raise ObsoleteFunction("use GetUnionSoupAlways()")

def RegisterCardSoup(soupName, indexArray, appSymbo, appObject):
    raise ObsoleteFunction("use RegUnionSoup().")

def SetupCardSoups():
    raise ObsoleteFunction("use RegUnionSoup().")

def UnionSoupIsNull(unionSoup):
    raise ObsoleteFunction("no null soups from GetUnionSoupAlways()")

def UnRegisterCardSoup(soupName):
    raise ObsoleteFunction("use UnRegUnionSoup().")


#############################################################################
#  cursor functions

def MapCursor(cursor, function):
    pass


#-- obsolete functions

def Query(soupOrUSoup, querySpec):
    raise ObsoleteFunction("use soupOrUSoup:Query() method")


#############################################################################
# VBO functions

def IsVBO(vbo):
    return

def GetVBOStore(vbo):
    return

def GetVBOStoredSize(vbo):
    return

def GetVBOCompander(vbo):
    return


#############################################################################
#  package functions

def GetPackageNames(store):
    pass

def GetPackages():
    pass

def GetPkgRef(name, store):
    pass

def GetPkgRefInfo(pkgRef):
    pass

def IsPackage(obj):
    """Is the supplied object of pkgRef?"""
    return 

def IsPackageActive(pkgRef):
    return

def IsValid(obj):
    return

def ObjectPkgRef(obj):
    return

def MarkPackageBusy(pkgRef, appName, reason):
    return

def MarkPackageNotBusy(pkgRef):
    return

def SafeMovePackage(pkgRef, destStore):
    return

def SafeRemovePackage(pkgRef):
    return

def SafeFreezePackage(pkgRef):
    return

def ThawPackage(pkgRef):
    return


#############################################################################
