#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/DeskPadDevice.py,v $
# Version:     $RCSfile: DeskPadDevice.py,v $ $Revision: 1.4 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""
DeskPadDevice

This module contains the device drivers for the DeskPad
implementation.  These are specific to the DeskPad environment.


"""

#############################################################################

import sys

from   DeviceDriver             import DeviceDriver
from   Device                   import Device

#############################################################################

def install(mgr):
    """Load and initialise the driver(s)."""

    mgr.RegisterDriver(DPHeapDriver)
    mgr.RegisterDriver(DPPowerDriver)
    mgr.RegisterDriver(DPBacklightDriver)
    mgr.RegisterDriver(DPDisplayDriver)
    mgr.RegisterDriver(DPMouseDriver)

    return


#############################################################################

class DPHeapDriver(DeviceDriver):
    """DeskPad heap driver."""

    def __init__(self, mgr):
	pass

    def Type(self):
	return "heap"

    def Name(self):
	return "DPHeap"

    def NewDevice(self, t_param):
	return DPHeapDevice(self, t_param)

#############################################################################

class DPPowerDriver(DeviceDriver):

    def __init__(self, mgr):
	pass

    def Type(self):
	return "power"

    def Name(self):
	return "DPPower"

    def NewDevice(self, t_param):
	return DPPowerDevice(self, t_param)

#############################################################################

class DPBacklightDriver(DeviceDriver):

    def __init__(self, mgr):
	pass

    def Type(self):
	return "backlight"

    def Name(self):
	return "DPBacklight"

    def NewDevice(self, t_param):
	return DPBacklightDevice(self, t_param)

#############################################################################

class DPDisplayDriver(DeviceDriver):

    def __init__(self, mgr):
	self._mgr = mgr

    def Type(self):
	return "display"

    def Name(self):
	return "DPDisplay"

    def NewDevice(self, t_param):
	return DPDisplayDevice(self, t_param)

#############################################################################

class DPMouseDriver(DeviceDriver):

    def __init__(self, mgr):
	pass

    def Type(self):
	return "digitiser"

    def Name(self):
	return "DPMouse"

    def NewDevice(self, t_param):
	return DPMouseDevice(self, t_param)

#############################################################################

class DPHeapDevice(Device):
    def __init__(self, ref_drv, t_param):
	pass

    def DriverName(self):
	return "DPHeap"

class DPPowerDevice(Device):
    def __init__(self, ref_drv, t_param):
	pass

    def DriverName(self):
	return "DPPower"

class DPBacklightDevice(Device):
    def __init__(self, ref_drv, t_param):
	pass

    def DriverName(self):
	return "DPBacklight"

    def TurnOn(self):
	pass

    def TurnOff(self):
	pass

    def Toggle(self):
	pass


class DPDisplayDevice(Device):

    def __init__(self, ref_drv, t_param):
	self._driver = ref_drv
	self._param = t_param

	self._tk = self._driver._mgr._gnut._dev.tk
	self._canvas = self._driver._mgr._gnut._dev._screen

	return


    def DriverName(self):
	return "DPDisplay"


    def Canvas(self):
	"""Return the canvas handle."""

	return self._canvas

    def Update(self):
	self._tk.update()
	return

    def getWidth(self):
	return 320

    def getHeight(self):
	return 480

class DPMouseDevice(Device):
    def __init__(self, ref_drv, t_param):
	pass

    def DriverName(self):
	return "DPMouse"


#############################################################################
