#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/Device.py,v $
# Version:     $RCSfile: Device.py,v $ $Revision: 1.2 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

class Device:

    def __init__(self, driver, params):
	self._driver = driver

    def DeviceType(self):
	return self._driver.Type()

    def DriverName(self):
	return self._driver.Name()

    def IsShareable(self):
	return self._driver.shareable()


#############################################################################

class MemoryDevice(Device):
    pass

class StorageDevice(MemoryDevice):
    pass

class HeapDevice(MemoryDevice):
    pass

class BitmapDevice(Device):
    pass

class BitmapOutputDevice(BitmapDevice):
    pass

class DisplayDevice(BitmapOutputDevice):
    pass

class PrinterDevice(BitmapOutputDevice):
    pass

class BitmapInputDevice(BitmapDevice):
    pass

class DigitiserDevice(BitmapInputDevice):
    pass

class ScannerDevice(BitmapInputDevice):
    pass

class CommsDevice(Device):
    pass

class FaxModemDevice(CommsDevice):
    pass

class SerialDevice(CommsDevice):
    pass

class ParallelDevice(CommsDevice):
    pass

class IrDevice(CommsDevice):
    pass

class LocalTalkDevice(CommsDevice):
    pass

class EthernetDevice(CommsDevice):
    pass

class USBDevice(CommsDevice):
    pass

class ADBDevice(CommsDevice):
    pass

class CardDevice(Device):
    pass

class GenericDevice(Device):
    pass

class TemperatureDevice(GenericDevice):
    pass

class BacklightDevice(GenericDevice):
    pass

class PowerDevice(GenericDevice):
    pass


#############################################################################

