#! /usr/bin/env python
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/Errors.py,v $
# Version:     $RCSfile: Errors.py,v $ $Revision: 1.4 $
# Copyright:   (C) 1997-1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""
Errors

Definition of basic Gnuton error codes.

"""

#############################################################################

err_lst = \
{
    #-- common errors

         0 : "No Error",
     -7000 : "Not enough memory available",

    #-- application errors

     -8001 : "PCMCIA card battery must be replaced",
     -8002 : "PCMCIA card battery is running low",
     -8003 : "Nothing to undo",
     -8004 : "The routing slip isd already open",
     -8005 : "Close box must be tapped to hang up the modem",
     -8006 : "Nothing to print",
     -8007 : "Exception not handled",
     -8008 : "The length of a styles slot had to be extended",
     -8009 : "A length in the read-only styles slot is too short to display the text",
     -8010 : "Communications card has been inserted",
     -8011 : "Note has too many items",
     -8012 : "Note is too large",
     -8013 : "Hote is too long",
     -8100 : "Blank not could not be created",
     -8101 : "Item could not be moved",
     -8102 : "Changes could nto be saved",
     -8103 : "A problem has occurred",
     -8104 : "Problem with the PCMCIA card",
     -8105 : "Note could not be changed",

    #-- package errors

    -10401 : "Bad package",
    -10402 : "Package already exists",
    -10403 : "Bad package version",
    -10404 : "Unexpected end of package",
    -10405 : "Unexpected end of package part",
    -10406 : "Part type is already registered",
    -10407 : "Part type is not registered",
    -10408 : "No such package exists",
    -10409 : "Newer package already exists",
    -10410 : "Newer version of application already installed",

    #-- PCMCIA card errors

    -10501 : "Unrecognised card",
    -10502 : "Card not ready",
    -10503 : "Bad power on card",
    -10504 : "Unexpected card error",
    -10505 : "Card reset",
    -10506 : "Card is not initialised",
    -10507 : "Card service is not installed",
    -10508 : "Card service is not suspended",
    -10509 : "Card service has not been resumed",
    -10510 : "No usage configurations on card",
    -10511 : "Card could not be formatted",
    -10512 : "Card could not be formatted because it is write protected",
    -10520 : "Bad CIS parser procedure pointer",
    -10521 : "Unknown tuple is CIS",
    -10522 : "Unknown subtuple in CIS",
    -10523 : "CIS tuple order is bad",
    -10524 : "CIS tuple size is bad",
    -10525 : "CIS tuple specified as no link has link",
    -10526 : "CIS tuple specified as with link has no link",
    -10527 : "CIS tuple link target is bad",
    -10528 : "Bad CIS tuple version 1",
    -10529 : "Bad CIS tuple version 2",
    -10530 : "Bad CIS JEDEC tuple",
    -10531 : "Bad CIS checksum",
    -10532 : "Missing CIS",
    -10533 : "Blank CIS",
    -10534 : "Bad CIS",
    -10535 : "Bad link target C",

    #-- flash card errors

    -10551 : "Flash card is busy",
    -10552 : "Flash card is not erasing",
    -10553 : "Flash card erase is not suspended",
    -10554 : "Flash card suspend erase error",
    -10555 : "Flash card erase failed",
    -10556 : "Flash card write failed",
    -10557 : "Flash card Vpp is low",
    -10558 : "Flash card error in sleep",
    -10559 : "Flash card does not have enough power",

    #-- card store errors

    -10600 : "Attempt to read or write outside of object bounds",
    -10601 : "Bad buffer pointer",
    -10602 : "Bad card access",
    -10603 : "Bad storage type",
    -10604 : "Store not found",
    -10605 : "The store has been write protected by the user",
    -10606 : "Object not found",
    -10607 : "Flash card block is full",
    -10608 : "Flash card is not virting",
    -10609 : "Write error (one or more bits failed to assert)",
    -10610 : "No more obejcts",
    -10611 : "Flash card erase in progress",
    -10612 : "Card is full",
    -10613 : "No more blocks left in search on flash card",
    -10614 : "Flash card log is full",
    -10615 : "Card needs to be formatted",
    -10616 : "Bad or unknown PSSID",
    -10617 : "Card memory is full",
    -10618 : "Missing or low battery on SRAM card",
    -10619 : "Attempt to modify store without a transaction in effect",
    -10620 : "Tranmsaction aborted",
    -10621 : "Card needs recovery, but is write-protected",
    -10622 : "Object too large for store",

    #-- generic AppleTalk errors

    -12001 : "Buffer too small or corrupted",
    -12002 : "Event is pending",
    -12003 : "Cancelled",
    -12004 : "Attempt to cancel failed",
    -12005 : "No handler for cancel",
    -12006 : "Unknown message receiver",
    -12007 : "Cannot create AppleTalk port",
    -12008 : "Cannot create AppleTalk task",
    -12009 : "Not implemented",
    -12010 : "Data length error",
    -12011 : "No such subject available to open",
    -12012 : "Not opened",
    -12013 : "AppleTalk is not open",
    -12014 : "AppleTalk is already open",
    -12015 : "Duration is too small",
    -12016 : "Duration is too large",

    #-- LAP protocol errors

    -12100 : "LAP read link failed",
    -12101 : "LAP all protocols in use",
    -12102 : "No protocol handler",
    -12103 : "No such command",
    -12104 : "Bad link",

    #-- DDP protocol errors

    -12200 : "No such DDP command",
    -12201 : "Invalid socket",
    -12202 : "Not in static socket range",
    -12203 : "Not in dynamic socket range",
    -12204 : "Socket is already open",
    -12205 : "Socket not open",
    -12206 : "Scoket internal socket",
    -12207 : "Socket is in use",
    -12208 : "Unknown LAP type",
    -12209 : "DDP back check sum",
    -12210 : "Bad packet size",
    -12211 : "No listener for socket",
    -12212 : "No such protocol type known",
    -12213 : "External client timed out",

    #-- NBP protocol errors

    -12300 : "Bad form",
    -12301 : "Name is already registered",
    -12302 : "Too many names",
    -12303 : "Name is not registered",
    -12304 : "Too many names requested",
    -12305 : "Too many lookups are pending",
    -12306 : "Not a NBP packet DDP type",
    -12307 : "Unknown NBP function",
    -12308 : "Unknown NBP lookup reply",
    -12309 : "Too many tuples in lookup request",
    -12310 : "NBP lookup is in use",
    -12311 : "NBP index out of range",
    -12312 : "NBP lookup aborted",
    -12313 : "No such command",
    -12314 : "No names found",

    #-- AEP protocol errors

    -12400 : "No such command",
    -12401 : "Not an echo packet DDP type",
    -12402 : "AEP packet size is zero",
    -12403 : "AEP function not requested",

    #-- RTMP protocol errors

    -12500 : "No such command",
    -12501 : "Packet size is zero",
    -12502 : "RTMP routed",
    -12503 : "RTMP address unresolved",
    -12504 : "RTMP no router available",

    #-- ATP protocol errors

    -12600 : "No such command",
    -12601 : "No ATP packet DDP type",
    -12602 : "Unknown ATP function",
    -12603 : "ATP request data length is zero",
    -12604 : "Expected responses are out of range",
    -12605 : "Response buffer is too small",
    -12606 : "ATP retry duration too small",
    -12607 : "ATP transaction timed out",
    -12608 : "Responding socket already open",
    -12609 : "Responding socket not open",
    -12610 : "Response packet length bad",
    -12611 : "Bad number of response packets",
    -12612 : "Socket already has a request on autorequest",

    #-- PAP protocol errors

    -12700 : "No such command",
    -12701 : "Unexpected connection ID",
    -12702 : "Invalid connection ID",
    -12703 : "Invalid responder socket",
    -12704 : "Unexpected function",
    -12705 : "Printer is busy",
    -12706 : "Unexpected connection open result",
    -12707 : "Bad flow quantum requested",
    -12708 : "Connection timed out",
    -12709 : "EOF sent",
    -12710 : "PAP flushed",
    -12711 : "Printer terminated connection",
    -12712 : "Printer not found",
    -12713 : "No status available",
    -12714 : "No data available",
    -12715 : "The buffer the was passed is too small",
    -12716 : "Put data operation timed out",

    #-- ZIP protocol errors

    -12800 : "No zones",

    #-- ADSP protocol errors

    -12900 : "Too many ADSP connections",
    -12901 : "ADSP mode invalid",
    -12902 : "ADSP packet size bad",
    -12903 : "ADSP control type bad",

    #-- communications tool errors

    -16005 : "Cancelled",
    -16009 : "Phone connection was cut off",
    -16013 : "Cancelled",
    -16021 : "No phone number was provided",

    #-- serial tool errors

    -18003 : "Bad connection",

    #-- fax errors

    -22001 : "FAX could not be sent",
    -22002 : "FAX could not be sent",
    -22003 : "FAX could not be sent",
    -22004 : "FAX could not be sent",
    -22005 : "FAX machine had a problem printing some pages",
    -22006 : "FAX could not be sent",
    -22007 : "FAX could not be sent",

    #-- modem errors

    -24000 : "No modem is connected",
    -24001 : "There is no dial tone",
    -24002 : "There is no answer",
    -24003 : "The phone number is busy",
    -24004 : "There is no answer",
    -24005 : "Your modem is not responding properly",
    -24007 : "The modem is not responding properly",

    #-- Sharp IR errors

    -38001 : "No response",
    -38002 : "Cancelled",
    -38006 : "Bad connection",
    -38008 : "Beaming error",

    #-- online service errors

    -40102 : "Lost connection to host",
    -40103 : "Lost connection to host",
    -40104 : "The host is not responding",
    -40105 : "There is a problem reading from the host",
    -40106 : "Failed to connect to local access number",

    #-- printing errors

    -44000 : "Printer problem",
    -44001 : "Newton is unable to print",
    -44002 : "No printer is connected",
    -44003 : "Printer busy",
    -44004 : "Printing stopped",
    -44005 : "Lost contact with the printer",
    -44100 : "The next sheet of paper must be inserted",
    -44101 : "The phone number must be dialed now",
    -44102 : "There is no paper tray",
    -44103 : "The wrong paper tray is attached",
    -44104 : "The paper has no paper",
    -44105 : "The printer has no ink",
    -44106 : "The printer is jammed",
    -44107 : "The pritner door is open",
    -44108 : "The printer is offline",

    #-- store and soup errors

    -48001 : "The PCMCIA card is not a data storage card",
    -48002 : "Store format is too old to understand",
    -48003 : "Store format is too new to understand",
    -48004 : "Store is corrupted; can't recover",
    -48005 : "Single object is corrupted; can't recover",
    -48009 : "Not a soup entry",
    -48010 : "Tried to remove a store that was not registered",
    -48011 : "Soup index has an unknown type",
    -48012 : "Soup index has an unknown key structure",
    -48013 : "Soup index does not exist",
    -48014 : "A soup with this name already exists",
    -48015 : "Tried to CopyEntries to a union soup",
    -48016 : "Soup is invalid (probably from a removed store)",
    -48017 : "Soup is invalid (probably from a removed store)",
    -48018 : "Entry is invalid (probably from a removed store)",
    -48019 : "Key does not have the type specified in the index",
    -48020 : "Store is in ROM",
    -48021 : "Soup already has an index with this path",
    -48022 : "Internal error-something unexpected happened",
    -48023 : "Tried to call RemoveIndex on the _uniqueID index",
    -48024 : "Query type missing or unknown",
    -48025 : "Discovered index inconsistency",

    #-- object system errors

    -48200 : "Expected a frame, array or binary object",
    -48202 : "Empty path",
    -48203 : "Invalid segment in path expression",
    -48204 : "Path failed",
    -48205 : "Index out of bounds (string or array)",
    -48206 : "Source and destination must be different objects",
    -48207 : "Long out of range",
    -48210 : "Bad arguments",
    -48211 : "String too big",
    -48214 : "Object is read only",
    -48215 : "Functionality is unimplemented",

    #-- bad type errors

    -48400 : "Expected a frame",
    -48401 : "Expected an array",
    -48402 : "Expected a string",
    -48403 : "Expected a pointer",
    -48404 : "Expected a number",
    -48405 : "Expected a real",
    -48406 : "Expected an integer",
    -48407 : "Expected a character",
    -48408 : "Expected a binary object",
    -48409 : "Expected a path expression (or a symbol or integer)",
    -48410 : "Expected a symbol",
    -48411 : "Expected a symbol",
    -48412 : "Expected a frame or an array",
    -48413 : "Expected an array or nil",
    -48414 : "Expected a string or nil",
    -48415 : "Expected a binary object or nil",
    -48416 : "Unexpected frame",
    -48417 : "Unexpected binary object",
    -48418 : "Unexpected immediate",

    #-- interpreter errors

    -48800 : "Not in a break loop",
    -48802 : "Too many arguments for a CFunction",
    -48803 : "Wrong number of arguments",
    -48804 : "FOR loop BY expression has zero value",
    -48806 : "No current exception",
    -48807 : "Undefined variable",
    -48808 : "Undefined global function",
    -48809 : "Undefined method",
    -48810 : "No _proto for inherited send",
    -48811 : "Tried to access slot in nil context",
    -48814 : "Local variables and FOR/WITH loops not allowed at top level",
    
}


#############################################################################
