#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/GUI.py,v $
# Version:     $RCSfile: GUI.py,v $ $Revision: 1.2 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
""" """
#############################################################################

import sys
#import Tkinter


#############################################################################

VERSION = "$Revision: 1.2 $"[11:-2]


#############################################################################

class GUI:
    """

    """

    def __init__(self, ref_gnut):
	"""Create a GNUton GUI instance.

	"""

	r = rivet.init()
	self.__root = r

	c = r.canvas(width=480, height=640, 
		     borderwidth=0,
		     highlightthickness=0)
	c.pack()
	#rivet.bind(c, "<1>", sys.exit)

	rivet.wm.title(r, "GNUton")

	#-- view manager
	set_newt(c)

	#-- create root view
	self.log("root view, ")
	self.fr_root = Frame()
	self.fr_root["viewBounds"] = {"left": 0,
				      "top": 0,
				      "right": 480,
				      "bottom": 600}
	self.v_root = View(self.fr_root, None)
	self.v_root["viewCObject"].draw()

	
	#-- button bar
	self.log("button bar")
	self.bb = ButtonBar(c)
	self.bs = BScroller(c, 440, 600)

	self.extras = Extras(c, 0, 600)

	self.log(".\n")


#############################################################################

class ButtonBar:
    """ """

    def __init__(self, newt):
	""" """

	self.newt = newt
	newt.create("rectangle", 
		    0, 640, 
		    480, 600, 
		    outline="",
		    width=0,
		    tags="buttonbar")
	return


#############################################################################

class BScroller:
    """A 40x40 region with the arrows and belly-button."""

    def __init__(self, r, x, y, *vargs, **kargs):
	""" """

	r.create("oval",  
		 x+2,  y+14, 
		 x+14, y+26,
		 fill="black", 
		 tags="belly")

	r.create("polygon", 
		 x+30, y+0,
		 x+40, y+10,
		 x+35, y+10,
		 x+35, y+15,
		 x+25, y+15,
		 x+25, y+10,
		 x+20, y+10,
		 x+30, y+0,
		 fill="black",
		 tags="up")

	r.create("polygon", 
		 x+30, y+40,
		 x+40, y+30,
		 x+35, y+30,
		 x+35, y+25,
		 x+25, y+25,
		 x+25, y+30,
		 x+20, y+30,
		 x+30, y+40,
		 fill="black",
		 tags="down")

	r.tag_bind("belly", "<1>", self.doOverview)
	r.tag_bind("up", "<1>", self.doUp)
	r.tag_bind("down", "<1>", self.doDown)

	return


    def doUp(self):
	print "up"

    def doDown(self):
	print "down"

    def doOverview(self):
	print "overview"


#############################################################################

class Extras:
    """A 40x40 region for the Extras drawer button."""

    def __init__(self, r, x, y, *vargs, **kargs):
	""" """
	rivet.image.create("photo", "extras",
			   file="extras.gif")
	r.create("image",  
		 x+5,  y+3, 
		 anchor="nw",
		 image="extras",
		 tags="extras")

	r.create("text",
		 x, y+27,
		 text="Extras",
		 anchor="nw",
		 fill="black",
		 font="-*-fixed-*-r-normal-*-13-*-*-*-*-*-iso8859-*",
		 justify="center",
		 tags="extras")

	r.tag_bind("extras", "<1>", self.viewClick)

	return


    def viewClick(self):
	print "click"


#############################################################################

if __name__ == '__main__':

    rivet.mainloop()


#############################################################################


