#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/Gnuton.py,v $
# Version:     $RCSfile: Gnuton.py,v $ $Revision: 1.16 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
""" """

#############################################################################

import sys

from   Constants          import *
from   View               import *
from   ViewManager        import *
from   Classes            import Frame, Array, Binary

from   AppManager         import AppManager
from   StorageManager     import StorageManager
from   HardwareManager    import HardwareManager
from   MemoryManager      import MemoryManager
from   ViewManager        import ViewManager

from   devtest            import test

import Globals


#############################################################################

__version__ = "$Revision: 1.16 $"[11:-2]
__author__  = "davida@pobox.com"

#############################################################################

BOOTMSG  = """
GnutOS v%s
Copyright (C) %s, David Arnold.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Booting ...
"""

REVISION = "$Revision: 1.16 $"[11:-2]
VERSION  = "0.1"
YEAR     = "$Date: 1998/06/16 14:08:48 $"[7:11]


#############################################################################

class Gnuton:
    """

    The generic Gnuton implementation.  This class (and those that is
    uses) implement GnutOS.  It is generic in that it is parameterised
    by a boot block which adapts it to a specific hardware
    environment.

    This class acts mainly as a focal point for the other classes that
    do most of the work of the GnutOS implementation.  Fundamental
    amongst them are the various Manager classes: HardwareManager,
    MemoryManager, StorageManager, AppManager and ViewManager.

    In particular, the HardwareManager maintains an abstract view of
    the underlying hardware, providing common driver interfaces to a
    standard hierarchy of devices.  On top of this, the other managers
    implement the sub-systems of the GnutOS.

    """

    def __init__(self, device):
	"""Create a Gnuton instance.

	*device*   -- hardware-specific loader
	Returns    -- None, and only when it is exiting
	Exceptions -- none: any that make it to this level are bugs

	Initialisation of this class has several steps:

	1. initialise its basic state. Requires a boot block.
           Performs some sanity checks on the boot parameters.

	2. Create the MemoryManager (what driver?)

	3. Create the HardwareManager.  Use the boot block device list
	   to create drivers for all available (compatible) hardware.

	4. Create the AppManager.  This step initialises the
	   NewtonScript virtual machine.

	5. Create the ViewManager.  If the boot block includes a saved
	   view state, reload it, otherwise, create a new root view,
	   button bar and backdrop app.

	6. Create the StorageManager.  The HardwareManager has already
	   identified 'store-able' devices: validate and mount any
	   available stores (must be at least one).

	At this point, the device should be in the same state as when
	it shutdown (unless it has never booted before).  Note that it
	is possible to snapshot the state of a Gnuton at any time,
	letting the user restart from specified state.

	Note:
	This boot process is subject the change, but it won't normally
	worry you."""

	#-- initialise global state
	self._dev = device
	self._conf = device.config()

	self.log(BOOTMSG % (VERSION, YEAR))

	#-- memory manager
	self.log("Initialising memory: ")
	self._mm = None  #fixme: hmmm ...

	Globals.gnut = self
	self.log("Ok\n")

	#-- hardware manager
	self._hm = HardwareManager(self)

	#-- read boot block and initialise drivers
	self.log("Initialising drivers:")
	for drv in self._conf[None]:
	    self._hm.LoadDriver(drv)

	#-- sanity check: do we have drivers for required devices?
	self.log(" Ok.\n")

	#-- initialise devices
	self.log("Initialising devices:")
	for drv in self._hm.ListDrivers():        # forall loaded drivers
	    if self._conf.has_key(drv):           # if any devices?
		for param in self._conf[drv]:     # create device with params
		    dev = self._hm.CreateDevice(drv, param)
		    self._hm.RegisterDevice(dev)

	#-- sanity check: do we have all required devices?
        self.log(" Ok.\n")


	#-- applications manager
	self.log("Initialising application support: ")
	self._am = AppManager(self)
	self.log("Ok\n")

	#-- view manager
	self.log("Initialising view system: ")
	self._vm = ViewManager(self)
	self.log("Ok\n")

	#-- storage manager
	self.log("Initialising storage: ")
	self._sm = StorageManager(self)
	self.log("Ok\n")

	return


    def destroy(self):

	#-- storage manager
	self.log("Finalising storage: ")

	self.log("Ok\n")

	#-- view manager
	self.log("Finalising view system: ")

	self.log("Ok\n")

	#-- applications manager
	self.log("Finalising application support: ")

	self.log("Ok\n")

	#-- hardware manager
	self.log("Finalising hardware: ")

	self.log("Ok\n")

	#-- memory manager
	self.log("Finalising memory: ")

	self.log("Ok\n")

	self.log("Gnuton exiting.\n")

	return


    def run(self):
	"""Enter the main event loop."""

	self.log("Entering main event loop ...\n\n")

	test(self)  #fixme: testing broken-ness

	self.log("\nCompleted main event loop.\n")
	return


    def reset(self, mode=0):
	"""Reset the Gnut.

	"mode"          integer, 0 = soft, 1 = hard
	"Returns"       (?)
	"Exceptions"    (none)

	Apple Newtons had multiple levels of reset: from the OMP to
	the MessagePad 130, "hard" and "soft" reset were available.
	the MP2000 introduced a third level of reset.

	GNUton supports two levels of reset:

	"soft" reset maintains the content of all stores, but destroys
	all open views.  this means that any running application will
	be shut down, and some data entered but not saved could be
	lost.  soft resets are sometimes necessary to clean up the
	GNUton heap after applications which use too much heap.

	"hard" reset destroys the contents of the internal store.  The
	internal store had special meaning on the Apple Newtons -- it
	was flash RAM built into the device.  With GNUton, the
	internal store is a data file which is erased and recreated
	during a hard reset."""

	pass


    def log(self, txt, level=10):
	"""Write a message to the system console.

	"txt"           string, text to write to console
	"level"         integer, used for filtering. 0 unimportant, 10 very
	"Returns"       (none)
	"Exceptions"    (none)"""

	if not self._dev:
	    return

	self._dev.log(txt, level)
	return


    def config(self):
	"""Return a reference to the boot block/config table."""

	return self._conf


    def Device(self):
	"""Return a reference to the hosting device."""

	return self._dev


#############################################################################

if __name__ == '__main__':
    print "Cannot execute this without a boot block.  Try running DeskPad."
    sys.exit(1)


#############################################################################


