#! /usr/bin/env python
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/Symbols.py,v $
# Version:     $RCSfile: Symbols.py,v $ $Revision: 1.2 $
# Copyright:   (C) 1997-1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""
Symbols

Definition of basic Gnuton symbols.  Symbols are binary objects, with
a unique class -- the special immediate 0x55552 (kSymbolClass).  Data
consists of a 4-byte hash value, followed by a NUL-terminated, ASCII
string name.

"""

#############################################################################

kSymbolClass = 0x55552


#############################################################################

def make_symbol_hash(str_name):
    """Calculate the symbol hash given its name."""

    res = 0L
    da = ord("a") - ord("A")
    seed =  2654435769L

    for c in str_name:
	if c >= "a" or c <= "z":
	    res = res + ord(c) - da
	else:
	    res = res + c

    return (res * seed) & 0xffffffff


def make_symbol(str_name):
    """Create and return a symbol object for the given string."""

    pass


#############################################################################

sym_lst = [
    "int",
    "char",
    "boolean",
    "string",
    "array",
    "frame",
    "function",
    "symbol",
    "real",
    "immediate",
    "binary",
    "CodeBlock",
    "instructions",
    "literals",
    
    ]


#############################################################################

