#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/ViewPrimitives.py,v $
# Version:     $RCSfile: ViewPrimitives.py,v $ $Revision: 1.1 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

import sys

from   ViewConstants      import *


#############################################################################

DEFAULT_CONF = {
    "viewJustify": {},
    "viewFlags": vClickable,
    "viewFormat": {},
    "viewBounds": {"left":0, "top":0, "right":0, "bottom":0},
}

#############################################################################

class PView:
    """the primitive view class, the one that actually draws stuff."""

    def __init__(self, ref_gnut, view):
	"""Initialise the primitive view object."""

	self._gnut = ref_gnut
	self._view = view
	self._conf = DEFAULT_CONF

	return


    def configure(self):
	"""Configure the view."""

 	for key in self._view.keys():
	    self._conf[key] = self._view[key]

	return


    def draw(self):
	"""Draw the view."""

	#-- view type (viewClass)

	#-- determine size & position (viewBounds, viewJustify)
	x1 = 10
	x2 = 110
	y1 = 10
	y2 = 110

	#-- frame colour, width, fill colour (viewFormat)
	frame_colour = "Black"
	frame_width = 1
	fill_colour = "white"

	#-- effects (viewEffect)
	
	w = r.create("rectangle", 
		     x1, y1, x2, y2,
		     fill=fill_colour,
		     outline=frame_colour,
		     width=frame_width,
		     tags=None,)


	#-- behaviour (viewFlags)
	if self._conf["viewFlags"] & vClickable:
	    r.tag_bind(w, "<1>", self._view.ViewClickScript)

	return


#############################################################################

if __name__ == "__main__":
    pass


#############################################################################
