#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/play/gnuton/lib/RCS/defs.py,v $
# Version:     $RCSfile: defs.py,v $ $Revision: 1.5 $
# Copyright:   (C) 1997-1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

basic constant definitions.

type tags for the Python datatype classes, type tags from raw
NewtonScript, exceptions and bytecodes are all defined here.

"""

#############################################################################

NS_NIL  = 0x02
NS_TRUE = 0x1a


CodeBlock = "CodeBlock"
VMError = "NSI.VMError"

SYM_IMMEDIATE = "Immediate"
SYM_BINARY    = "Binary"
SYM_FRAME     = "Frame"
SYM_ARRAY     = "Array"
SYM_INTEGER   = "Integer"
SYM_BOOLEAN   = "Boolean"
SYM_CHAR      = "Char"
SYM_POINTER   = "Pointer"
SYM_MAGIC     = "Magic"
SYM_SPECIAL   = "Special"
SYM_SYMBOL    = "Symbol"


#############################################################################

#PYNS_TRUE = Boolean(1)
PYNS_NIL  = None


#############################################################################

#-- bytecode definitions

#-- byte_count, operand_count, do_shift, mask, byte1, byte2, byte3, name

inst_table = [
(1,1,0, 0xFF,0x00,0x00,0x00,"BC_POP"),
(1,1,0, 0xFF,0x01,0x00,0x00,"BC_DUP"),
(1,1,0, 0xFF,0x02,0x00,0x00,"BC_RETURN"),
(1,1,0, 0xFF,0x03,0x00,0x00,"BC_SELF"),
(1,1,0, 0xFF,0x04,0x00,0x00,"BC_CLOSURE"),
(1,1,0, 0xFF,0x05,0x00,0x00,"BC_FOREACHNEXT"),
(1,1,0, 0xFF,0x06,0x00,0x00,"BC_FOREACHCOMPLETE"),
(3,3,0, 0xFF,0x07,0x00,0x07,"BC_ENDEXCEPTION"),
(1,1,0, 0xF8,0x18,0x00,0x00,"BC_PUSHLITERAL"),
(1,1,1, 0xF8,0x20,0x00,0x00,"BC_PUSHIMMEDIATE"),
(1,1,0, 0xF8,0x28,0x00,0x00,"BC_CALLGLOBAL"),
(1,1,0, 0xF8,0x30,0x00,0x00,"BC_CALLWITH"),
(1,1,0, 0xF8,0x38,0x00,0x00,"BC_SENDMESSAGE"),
(1,1,0, 0xF8,0x40,0x00,0x00,"BC_CONDSENDMESSAGE"),
(1,1,0, 0xF8,0x48,0x00,0x00,"BC_INHSENDMESSAGE"),
(1,1,0, 0xF8,0x50,0x00,0x00,"BC_CONDINHSENDMESSAGE"),
(1,3,0, 0xF8,0x58,0x00,0x00,"BC_GOTO"),
(1,3,0, 0xF8,0x60,0x00,0x00,"BC_GOTOIFNIL"),
(1,3,0, 0xF8,0x68,0x00,0x00,"BC_GOTOIFNOTNIL"),
(1,1,0, 0xF8,0x70,0x00,0x00,"BC_PUSHEXTERNAL"),
(1,1,0, 0xF8,0x78,0x00,0x00,"BC_PUSHLOCAL"),
(1,1,0, 0xF8,0x80,0x00,0x00,"BC_CREATEFRAME"),
(1,1,0, 0xF8,0x88,0x00,0x00,"BC_CREATEARRAY"),
(1,1,0, 0xFF,0x91,0x00,0x00,"BC_PUSHSLOTVALUE"),
(1,1,0, 0xFF,0x98,0x00,0x00,"BC_ASSIGNTOSLOT"),
(1,1,0, 0xFF,0x99,0x00,0x00,"BC_ASSIGNTOSLOTANDPUSH"),
(1,1,0, 0xF8,0xA0,0x00,0x00,"BC_ASSIGNTOLOCAL"),
(1,1,0, 0xF8,0xA8,0x00,0x00,"BC_ASSIGNTOEXTERNAL"),
(1,1,0, 0xF8,0xB0,0x00,0x00,"BC_INCREMENTLOCAL"),
(1,3,0, 0xF8,0xB8,0x00,0x00,"BC_FORLOOPGOTO"),
(1,1,0, 0xFF,0xC0,0x00,0x00,"BC_ADD"),
(1,1,0, 0xFF,0xC1,0x00,0x00,"BC_SUB"),
(1,1,0, 0xFF,0xC2,0x00,0x00,"BC_DEREF"),
(1,1,0, 0xFF,0xC3,0x00,0x00,"BC_ASSIGNTOARRAYANDPUSH"),
(1,1,0, 0xFF,0xC4,0x00,0x00,"BC_COMPEQ"),
(1,1,0, 0xFF,0xC5,0x00,0x00,"BC_NOT"),
(1,1,0, 0xFF,0xC6,0x00,0x00,"BC_COMPNEQ"),
(3,3,0, 0xFF,0xC7,0x00,0x07,"BC_MULT"),
(3,3,0, 0xFF,0xC7,0x00,0x08,"BC_FDIV"),
(3,3,0, 0xFF,0xC7,0x00,0x09,"BC_IDIV"),
(3,3,0, 0xFF,0xC7,0x00,0x0A,"BC_COMPLT"),
(3,3,0, 0xFF,0xC7,0x00,0x0B,"BC_COMPGT"),
(3,3,0, 0xFF,0xC7,0x00,0x0C,"BC_COMPGE"),
(3,3,0, 0xFF,0xC7,0x00,0x0D,"BC_COMPLE"),
(3,3,0, 0xFF,0xC7,0x00,0x0E,"BC_BAND"),
(3,3,0, 0xFF,0xC7,0x00,0x0F,"BC_BOR"),
(3,3,0, 0xFF,0xC7,0x00,0x10,"BC_BNOT"),
(3,3,0, 0xFF,0xC7,0x00,0x11,"BC_FOREACH"),
(3,3,0, 0xFF,0xC7,0x00,0x12,"BC_LENGTH"),
(3,3,0, 0xFF,0xC7,0x00,0x13,"BC_CLONE"),
(3,3,0, 0xFF,0xC7,0x00,0x14,"BC_SETCLASS"),
(3,3,0, 0xFF,0xC7,0x00,0x15,"BC_ADDARRAYSLOT"),
(3,3,0, 0xFF,0xC7,0x00,0x16,"BC_MAKESTRING"),
(3,3,0, 0xFF,0xC7,0x00,0x17,"BC_SLOTEXISTS"),
(3,3,0, 0xFF,0xC7,0x00,0x18,"BC_CLASSOF"),
(1,1,0, 0xF8,0xC8,0x00,0x00,"BC_ONEXCEPTION")
]


#############################################################################
