/*
	This is a light version of Tactile's globalData NTK extension.
	I removed everything but the evaluate stuff because WinNTK
	didn't like something (and I only need the evaluate stuff)
	I set the shortcut to shift-return.
	Besides, instead of adding slots to the keys array, I use the
	DefineKey method.

	globalData is a file by Rob Bruce from Tactile which only works
	on Macintosh.
	It used to be available on Tactile's FTP.
	See Tactile's website:
		http://www.tactile.com/
	With Rob Bruce's consent, I posted it to UNNA.
*/


// Use this command to evaluate stuff without being connected to the inspector.
// It's better than Apple's Evaluate Because it has a self context
// And it has a nice Apple - Enter Interface, Similar to Newton Evaluates
protoEditor.JustDoIt_Tactile := func(off, len) 
	begin
		local text := :Selection();
		if strLen(text) = 0 then
			begin
				local currentLine := :FindLine(off);
				local start := :lineStart(currentLine);
				local ends := :lineStart(currentLine+1);
				:SetSelection(start,ends-start);
				text := :selection();
				off := ends-len-1;
			end;

		self.tactile := compile(text);
		
		:SetSelection(off+len+1, 0);
		if (:TextLength() = off+len+1) then
			begin
				:ReplaceSelection("\n");			
				:SetSelection(:SelectionOffset()+1, 0);
			end;
		else
			begin
				:ReplaceSelection("\n");			
				:SetSelection(:SelectionOffset(), 0);
			end;
		print(:tactile());
		removeSlot(self,'tactile);
	end;

protoEditor:DefineKey( {key: 13, shift: true}, 'JustDoIt_Tactile);