/*
 * AppController.h
 * Interface for the application delegate.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file Reference/License.rtf for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <dwy@ace.net>, 1997.
 */

#import <appkit/appkit.h>

@class NSString;
@class NSArray;
@class NewtonController;

@interface AppController:Object
{
    id		consoleView;		/*" Newton console, within the image "*/
	id		statusView;			/*" Status line atop the image "*/
	id		progressView;		/*" Progress display "*/

	id		preferences;		/*" Preferences manager "*/
	id		slurpee;			/*" Slurpee manager "*/
	id		newton;				/*" Newton communications object "*/
	id		services;			/*" Services controller object "*/
}

/*" Published static instance "*/
extern AppController *appController;

/*" Returning the application controller "*/
+ (AppController *)controller;

/*" Dealing with accepted extensions "*/
- (NSArray *)arrayOfAcceptedExtensions;
- (BOOL)extensionIsAccepted:(NSString *)extension;

/*" Loading packages "*/
- (void)openPackage:(NSString *)packagePath;
- openNewtonPackage:sender;

/*" Managing the display "*/
- clearDisplay:sender;

/*" Sending data "*/
- sendPasteboard:sender;
- sendFile:sender binary:(BOOL)binaryFlag;
- sendTextFile:sender;
- sendBinaryFile:sender;

/*" Managing connections "*/
- startNewtonConnection:sender;
- (NewtonController *)newton;

@end

@interface AppController (ApplicationDelegate)

- appDidInit:sender;
- appWillTerminate:sender;
- (BOOL)appAcceptsAnotherFile:sender;
- (int)app:sender openFile:(const char *)path type:(const char *)type;

@end

