/*
 * AppControllerApplicationDelegate.m
 * Implementation of NeXTSTEP's Application delegate methods.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file Reference/License.rtf for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <dwy@ace.net>, 1997.
 */

#import <foundation/NSData.h>
#import <foundation/NSException.h>
#import <foundation/NSString.h>
#import <foundation/NSUtilities.h>

#import <TCKit/TCKit.h>

#import "Newton.h"
#import "Preferences.h"

@implementation AppController (ApplicationDelegate)

- appDidInit:sender
{
	if ([[Preferences preferences] connectOnStartup])
		[self startNewtonConnection:self];

	services = [[ServicesController alloc] init];
	[[NXApp appListener] setServicesDelegate:services];

    return self;
}

- appWillTerminate:sender
{
	[newton release];
	return self;
}

- (BOOL)appAcceptsAnotherFile:sender
{
    return YES;
}

- (int)app:sender openFile:(const char *)path type:(const char *)type
{
	if (![self extensionIsAccepted:[NSString stringWithCString:type]])
		return NO;

	[self openPackage:[NSString stringWithCString:path]];
    return YES;
}

@end
