/*
 * NewtonController.h
 * Model a Newton MessagePad device as an object.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file Reference/License.rtf for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <dwy@ace.net>, 1997.
 */

#import <foundation/NSObject.h>

@class NSString;
@class TCStream;

/*" Structure that describes the Newton serial event protocol packets "*/
typedef struct {
	char		eventHeader[4];
	char		eventHeaderExtended[4];
	char		eventCommand[4];
	unsigned	length;
	char	   *data;
} NewtonEvent;

/*" NewtonEvent packet headers for a NewtonEvent. "*/
#define kDNEHeader					"newt"
#define kDNEHeaderExtended			"dock"

/*" Command codes for a NewtonEvent. "*/
#define kDRequestToDock				"rtdk"
#define kDInitiateDocking			"dock"
#define kDNewtonName				"name"
#define kDSetTimeout				"stim"
#define kDResult					"dres"
#define kDLoadPackage				"lpkg"
#define kDDisconnect				"disc"

@interface NewtonController:NSObject
{
	id			delegate;				/*" Object delegate "*/
	TCStream	*stream;				/*" Stream used for communications "*/

	NSObject	*commObject;			/*" Communications prototype "*/

	BOOL isDocked;						/*" Docked with NCU/NBU etc "*/
	BOOL isAwaitingAsynchronousEvent;	/*" Async packet reception pending "*/
}

/*" Designated initializer "*/
- initWithObject:(NSObject *)anObject;

/*" Delegate methods "*/
- delegate;
- (void)setDelegate:delegate;

/*" Streams and descriptors "*/
- (TCStream *)stream;
- (int)descriptor;

/*" Sending data "*/
- (void)sendPasteboard;
- (void)sendContentsOfFile:(NSString *)fileName binary:(BOOL)binaryFlag;

/*" Returning state "*/
- (BOOL)isDocked;
- (BOOL)isAwaitingAsynchronousEvent;

/* Event processing "*/
+ (NewtonEvent *)dataContainsNewtonEvent:(NSData *)data;
- (NSData *)getOrRejectNextNewtonEvent;

@end

@interface Object (NewtonDelegate)

/*" Delegate methods "*/
- (BOOL)newtonWillProcessInput:(NewtonController *)newton;

- (void)newtonDidProcessInput:(NewtonController *)newton;
- (void)newton:(NewtonController *)newton didNotProcessData:(NSData *)data;

@end
