#import <foundation/NSString.h>
#import <foundation/NSData.h>

#import "NoteController.h"
#import "SlurpeeController.h"
#import "SlurpeeAdaptor.h"
#import "Preferences.h"

@implementation NoteController

- initWithParent:sender
{
	[super init];

	[NXApp loadNibSection:"NoteController.nib" owner:self];
	parent = sender;
	[window makeKeyAndOrderFront:self];
	[titleView selectText:nil];

    return self;
}

- saveNote:sender
{
	SlurpeeAdaptor *adaptor = [parent adaptorFromCurrentNewton];
	char *noteText = NULL;

	if ([textView textLength] > 0) {
		noteText = [[NSMutableData dataWithLength:([textView textLength]+1)]
			mutableBytes];
		[textView getSubstring:noteText start:0 length:[textView textLength]];
	}

	[adaptor setDelegate:self];
	[adaptor createNoteTitled:
			[NSString stringWithCString:[titleView stringValue]]
		contents:[SlurpeeAdaptor stringByConvertingUNIXtoMac:
			[NSString stringWithCString:(noteText ? noteText : "")]]
		font:[SlurpeeAdaptor newtonFontWithFamily:
			[[Preferences preferences] defaultFontFamily] face:0 
			size:[[Preferences preferences] defaultFontSize]]
		folder:[[Preferences preferences] defaultFolderForNotes]];

	[window close];

    return self;
}


@end
