#import <foundation/NSString.h>
#import <foundation/NSBundle.h>
#import <foundation/NSData.h>

#import <TCKit/TCKit.h>

#import "PackageController.h"

#import "TCNewtonPackage.h"
#import "AppController.h"
#import "NewtonController.h"
#import "SlurpeeAdaptor.h"

static NXCoord windowX = 200;
static NXCoord windowY = 800;

@implementation PackageController

- (void)_setFieldValues
{
	unsigned totalCompressed = 0, totalUncompressed = 0;
	unsigned i;
	NPPartHeader *firstPart;

	[titleMatrix setStringValue:[[[package packageName]
		dataUsingEncoding:NSNEXTSTEPStringEncoding
		allowLossyConversion:YES] bytes]];
	[descriptionView setText:[[[package copyrightInfo]
		dataUsingEncoding:NSNEXTSTEPStringEncoding
		allowLossyConversion:YES] bytes]];

	for(i = 0; i < [package partCount]; ++i) {
		NPPartHeader *p = [package partHeaderAtIndex:i];

		totalCompressed += NXSwapBigIntToHost(p->compressedSize);
		totalUncompressed += NXSwapBigIntToHost(p->uncompressedSize);
	}

	[[fieldsMatrix cellAt:0 :0] setStringValue:
		[[NSString stringWithFormat:LOCALIZED_STRING(@"compressionMessage",
			@"%dk compressed, %dk uncompressed", @""),
		(int)(totalCompressed / 1024), 
		(int)(totalUncompressed / 1024)]
			cString]];

	if ([[package packageSignature] isEqual:@"package0"])
		[[fieldsMatrix cellAt:1 :0] setStringValue:
			LOCALIZED_CSTRING(@"nos1xMessage", 
				@"Newton OS 1.x and compatibles", @"")];
	else if ([[package packageSignature] isEqual:@"package1"])
		[[fieldsMatrix cellAt:1 :0] setStringValue:
			LOCALIZED_CSTRING(@"nos2xMessage",
				@"Newton OS 2.x and compatibles", @"")];
	else
		[[fieldsMatrix cellAt:1 :0] setStringValue:
			LOCALIZED_CSTRING(@"nosUnknownMessage",
				@"Unknown version of Newton OS", @"")];

	[[fieldsMatrix cellAt:2 :0] setIntValue:[package packageVersion]];

	[[fieldsMatrix cellAt:3 :0] setStringValue:[[[package creationDate]
		descriptionWithCalendarFormat:
			@"%A, %d-%b-%Y %I:%M:%S%p %Z" timeZone:
				[NSTimeZone defaultTimeZone]] cString]];

	firstPart = [package partHeaderAtIndex:0];
	[[fieldsMatrix cellAt:4 :0] setStringValue:LOCALIZED_CSTRING(
		[NSString stringWithCString:firstPart->partType],
		@"Unknown part type", @"")];
}

- initWithData:(NSData *)someData title:(NSString *)title
{
	[super init];

	[NXApp loadNibSection:"NewtonPackage.nib" owner:self];

	windowX += 20;
	windowY -= 20;

	[window moveTopLeftTo:windowX :windowY];

	[installButton setEnabled:([appController newton] != nil)];

NS_DURING
	package = [[TCNewtonPackage alloc] initWithData:someData];

	[self _setFieldValues];
NS_HANDLER
	NXRunAlertPanel(LOCALIZED_CSTRING(@"errPackage", @"Package Error", @""),
		[[exception exceptionReason] cString], 
		LOCALIZED_CSTRING(@"cancel", @"Cancel", @""), NULL, NULL);
NS_ENDHANDLER
	[window setTitleAsFilename:[title cString]];
	[window makeKeyAndOrderFront:nil];

	return self;
}

- initWithContentsOfFile:(NSString *)fileName
{
	return [self initWithData:[NSData dataWithContentsOfFile:fileName]
		title:fileName];
}

- install:sender
{
	SlurpeeAdaptor *adaptor = [SlurpeeAdaptor adaptorWithStream:
		[[appController newton] stream]];

	[adaptor installPackageNamed:[package packageName] 
		data:[package packageData]];

    return self;
}

- saveAs:sender
{
	SavePanel *savePanel = [[[SavePanel new]
		setTreatsFilePackagesAsDirectories:YES]
		setRequiredFileType:LOCALIZED_CSTRING(@"savedPkgType", @"", @"")];
	if([savePanel runModal])
		[[package packageData] writeToFile:
			[NSString stringWithCString:[savePanel filename]]
			atomically:YES];

	return self;
}

- windowWillClose:sender
{
	[self free];
	return self;
}

- free
{
	[package release];
	return nil;
}

@end
