
#import <appkit/appkit.h>

#import "SwappablePreferences.h"

@interface FilingPreferences:SwappablePreferences
{
	id	folderButtonMatrix;
    id	folderNameView;
    id	notesFilingMenu;
    id	packagesFilingMenu;
}

- (NSArray *)standardFolderList;
- (NSString *)unfiledFolderLocalizedName;

- (NSArray *)customFolderList;
- (void)setCustomFolderList:(NSArray *)theList;

- (NSArray *)folderList;

- (NSString *)defaultFolderForNotes;
- (NSString *)defaultFolderForPackages;

- (void)setDefaultFolderForNotes:(NSString *)aFolder;
- (void)setDefaultFolderForPackages:(NSString *)aFolder;

- (void)addCustomFolderNamed:(NSString *)aFolder;
- (void)removeCustomFolderNamed:(NSString *)aFolder;

- addFolder:sender;
- removeFolder:sender;

- setNotesFolder:sender;
- setPackagesFolder:sender;

- (void)_setupMenus;

- (void)createNewtonFilingMenu:(PopUpList *)aMenu
	protoTarget:target protoAction:(SEL)anAction;

@end
