#import <foundation/NSString.h>
#import <foundation/NSArray.h>

#import <TCKit/TCKit.h>

#import "SwappablePreferences.h"
#import "Preferences.h"

#import "FilingPreferences.h"

@implementation FilingPreferences

- (NSString *)windowTitle
{
	return @"Filing & Folder";
}

- (NSString *)buttonTitle
{
	return @"Filing";
}

- (NSArray *)standardFolderList
{
	return [LOCALIZED_STRING(@"defaultFolders", @"", @"")
		componentsSeparatedByString:
			LOCALIZED_STRING(@"folderSeparator", @"", @"")];
}

- (NSString *)unfiledFolderLocalizedName
{
	return [[self standardFolderList] objectAtIndex:0];
}

- (NSArray *)customFolderList
{
	return [Preferences arrayForKey:@"CustomFolders" 
		withSeparator:LOCALIZED_STRING(@"folderSeparator", @"", @"")];
}

- (void)setCustomFolderList:(NSArray *)theList
{
	[Preferences setArray:theList forKey:@"CustomFolders"
		withSeparator:LOCALIZED_STRING(@"folderSeparator", @"", @"")];
}

- (NSArray *)folderList
{
	NSMutableArray *fullArray = [[[self standardFolderList] mutableCopy]
		autorelease];

	[fullArray addObjectsFromArray:[self customFolderList]];

	return [[fullArray copy] autorelease];
}

- (NSString *)defaultFolderForNotes
{
	if ([[Preferences stringForKey:@"DefaultNotesFolder"] length] != 0)
		return [Preferences stringForKey:@"DefaultNotesFolder"];
	else
		return [self unfiledFolderLocalizedName]; 
}

- (NSString *)defaultFolderForPackages
{
	if ([[Preferences stringForKey:@"DefaultPackagesFolder"] length] != 0)
		return [Preferences stringForKey:@"DefaultPackagesFolder"];
	else
		return [self unfiledFolderLocalizedName]; 
}

- (void)setDefaultFolderForNotes:(NSString *)aFolder
{
	[Preferences setString:aFolder forKey:@"DefaultNotesFolder"];
}

- (void)setDefaultFolderForPackages:(NSString *)aFolder
{
	[Preferences setString:aFolder forKey:@"DefaultPackagesFolder"];
}

- (void)addCustomFolderNamed:(NSString *)aFolder
{
	NSMutableArray *customFolders = [[self customFolderList] mutableCopy];

	if (![customFolders containsObject:aFolder])
		[customFolders addObject:aFolder];

	[self setCustomFolderList:customFolders];
}

- (void)removeCustomFolderNamed:(NSString *)aFolder
{
	NSMutableArray *customFolders = [[self customFolderList] mutableCopy];

	if ([customFolders containsObject:aFolder])
		[customFolders removeObject:aFolder];

	[self setCustomFolderList:customFolders];
}

- addFolder:sender
{
	[self addCustomFolderNamed:[NSString stringWithCString:
		[folderNameView stringValue]]];
	[self _setupMenus];

	return self;
}

- removeFolder:sender
{
	if (strcmp([notesFilingMenu title], [folderNameView stringValue]) == 0) {
		[self setDefaultFolderForNotes:[self unfiledFolderLocalizedName]];
		[[notesFilingMenu setTitle:[[self unfiledFolderLocalizedName]
			cString]] update];
	}
	if (strcmp([packagesFilingMenu title], [folderNameView stringValue]) == 0) {
		[self setDefaultFolderForPackages:[self unfiledFolderLocalizedName]];
		[[packagesFilingMenu setTitle:
			[[self unfiledFolderLocalizedName] cString]] update];
	}

	[self removeCustomFolderNamed:[NSString stringWithCString:
		[folderNameView stringValue]]];
	[self _setupMenus];

	return self;
}

- setNotesFolder:sender
{
	[self setDefaultFolderForNotes:[NSString stringWithCString:
		[[sender selectedCell] title]]];

	[folderNameView setStringValue:[[sender selectedCell] title]];
	[self textDidGetKeys:folderNameView isEmpty:NO];
	[notesFilingMenu setTitle:[[sender selectedCell] title]];

	return self;
}

- setPackagesFolder:sender
{
	[self setDefaultFolderForPackages:[NSString stringWithCString:
		[[sender selectedCell] title]]];
	[folderNameView setStringValue:[[sender selectedCell] title]];
	[self textDidGetKeys:folderNameView isEmpty:NO];
	[packagesFilingMenu setTitle:[[sender selectedCell] title]];

	return self;
}

- (void)_setupMenus
{
	[self createNewtonFilingMenu:[notesFilingMenu target]
		protoTarget:self
		protoAction:@selector(setNotesFolder:)];
	[self createNewtonFilingMenu:[packagesFilingMenu target]
		protoTarget:self
		protoAction:@selector(setPackagesFolder:)];

	[notesFilingMenu setTitle:[[self defaultFolderForNotes] cString]];
	[packagesFilingMenu setTitle:[[self defaultFolderForPackages] cString]];
}

- (void)willBecomeCurrentView:sender
{
	[super willBecomeCurrentView:sender];

	/* setup menus */
	[self _setupMenus];
}

- (void)createNewtonFilingMenu:(PopUpList *)aMenu
	protoTarget:target protoAction:(SEL)anAction
{
	NSEnumerator *e = [[self folderList] objectEnumerator];
	NSString *menuTitle;

	while ([aMenu count] > 0)
		[aMenu removeItemAt:0];

	while (menuTitle = [e nextObject])
		[[[aMenu addItem:[menuTitle cString]]
			setTarget:target]
			setAction:anAction];
}

- textDidGetKeys:sender isEmpty:(BOOL)aFlag
{
	NSString *entryString = [NSString stringWithCString:
		[sender stringValue]];

	/* Add */
	[[folderButtonMatrix cellAt:0 :0] setEnabled:([entryString length] > 0 &&
		![[self folderList] containsObject:entryString])];

	/* Remove */
	[[folderButtonMatrix cellAt:0 :1] setEnabled:([entryString length] > 0 &&
		[[self customFolderList] containsObject:entryString])];

	return self;
}

@end
