#import "HardwarePreferences.h"
#import <TCKit/TCKit.h>

@implementation HardwarePreferences

- (NSString *)windowTitle
{
	return @"Hardware";
}

- (NSString *)buttonTitle
{
	return @"Hardware";
}

- (unsigned)connectionPort
{
	return [Preferences integerForKey:@"NewtonConnection"];
}

- (void)setConnectionPort:(unsigned)portSpec
{
	[Preferences setInteger:portSpec forKey:@"NewtonConnection"];
}

- (BOOL)connectOnStartup
{
	return (BOOL)[NXApp readIntDefault:@"ConnectOnStartup"];
}

- (void)setConnectOnStartup:(BOOL)flag
{
	[Preferences setInteger:flag forKey:@"ConnectOnStartup"];
}

- (unsigned)portSpeed
{
	return [Preferences integerForKey:@"NewtonPortSpeed"];
}

- (void)setPortSpeed:(unsigned)portSpeed
{
	[Preferences setInteger:portSpeed forKey:@"NewtonPortSpeed"];
}

- (unsigned)timeout
{
	return [Preferences integerForKey:@"NewtonPortTimeout"];
}

- (void)setTimeout:(unsigned)timeout
{
	[Preferences setInteger:timeout forKey:@"NewtonPortTimeout"];
}

- update:sender
{
	[self setConnectionPort:[[portForm selectedCell] tag]];
	[self setPortSpeed:[[speedForm selectedCell] tag]];
	[self setConnectOnStartup:[autoConnectBox intValue]];
	[self setTimeout:[timeoutFormCell intValue]];

	return self;
}

- (void)willBecomeCurrentView:sender
{
	[super willBecomeCurrentView:sender];

	[portForm selectCellWithTag:[self connectionPort]];
	[speedForm selectCellWithTag:[self portSpeed]];
	[autoConnectBox setIntValue:[self connectOnStartup]];
	[timeoutFormCell setIntValue:[self timeout]];
}

@end
