/*
 * Preferences.h
 * Main preference management object.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file doc/LICENSE for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <david_young@thinkinc.com>, 1997.
 */

#import <appkit/appkit.h>

@class NSString;
@class NSArray;
@class NSMutableArray;
@class SwappablePreferences;

@interface Preferences : Object
{
	id delegate;					/*" delegate, not used. "*/

	Panel *panel;					/*" Preferences panel. "*/
	View *prefsView;				/*" Currently viewed preferences view. "*/
	Matrix *buttons;				/*" Matrix of buttons to select views. "*/
	NXStringTable *moduleTable;		/*" Table of sub-modules for each view. "*/

	NSMutableArray *viewSetArray;	/*" Array used to track modules "*/

	SwappablePreferences *emptySet;
			/*" A preference module without any controls. "*/
	SwappablePreferences *currentSet;
			/*" The currently active preference module. "*/
}

/*" Refreshing the panel "*/
- (void)reloadModules;
- (void)reloadButtonTitles;

/*" Accessing view sets "*/
- (SwappablePreferences *)currentViewSet;
- (SwappablePreferences *)emptyViewSet;

/*" Switching views "*/
- changeViewToViewSet:(SwappablePreferences *)aSet;
- changeViewToTag:(int)tag;
- changeView:sender;

@end

/* tack on class methods */

#import "PreferencesClassMethods.h"

@interface Preferences (PanelForwardedMethods)

- makeKeyAndOrderFront:sender;

@end


/* tack on preferences modules */

#import "PreferencesMethods.h"

