/*
 * PreferencesClassMethods.h
 * Auxilliary methods for preference management object.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file doc/LICENSE for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <david_young@thinkinc.com>, 1997.
 */

@interface Preferences (PreferencesClassMethods)

+ (Preferences *)preferences;

+ (NSString *)stringForKey:(NSString *)key;
+ (NSArray *)arrayForKey:(NSString *)key withSeparator:(NSString *)sep;
+ (int)integerForKey:(NSString *)key;
+ (BOOL)booleanForKey:(NSString *)key;

+ (void)setString:(NSString *)value forKey:(NSString *)key;
+ (void)setArray:(NSArray *)anArray forKey:(NSString *)key
  withSeparator:(NSString *)separator;
+ (void)setInteger:(int)value forKey:(NSString *)key;
+ (void)setBoolean:(BOOL)value forKey:(NSString *)key;

@end
