#import "Preferences.h"

#import <foundation/NSString.h>
#import <foundation/NSArray.h>
#import <foundation/NSUtilities.h>

#import "SwappablePreferences.h"
#import "NoPreferences.h"

extern Preferences *_preferences_sharedInstance;

@implementation Preferences (PreferencesClassMethods)

+ (Preferences *)preferences
{
	return _preferences_sharedInstance;
}

+ (NSString *)stringForKey:(NSString *)key
{
	if (NXReadDefault ([NXApp appName], [key cString]) != NULL)
		return [NSString stringWithCString:NXReadDefault ([NXApp appName], [key cString])];
	else
		return @"";
}

+ (NSArray *)arrayForKey:(NSString *)key withSeparator:(NSString *)sep
{
	if ([[self stringForKey:key] length] > 0)
		return [[self stringForKey:key] componentsSeparatedByString:sep];
	else
		return [[[NSArray alloc] init] autorelease];
}

+ (int)integerForKey:(NSString *)key
{
	return [[self stringForKey:key] intValue];
}

+ (BOOL)booleanForKey:(NSString *)key
{
	return (BOOL)[self integerForKey:key];
}

+ (void)setString:(NSString *)value forKey:(NSString *)key
{
	NXWriteDefault ([NXApp appName], [key cString], [value cString]);
}

+ (void)setArray:(NSArray *)anArray forKey:(NSString *)key
  withSeparator:(NSString *)separator
{
	[self setString:[anArray componentsJoinedByString:separator] forKey:key];
}

+ (void)setInteger:(int)value forKey:(NSString *)key
{
	[self setString:[NSString stringWithFormat:@"%d", value] forKey:key];
}

+ (void)setBoolean:(BOOL)value forKey:(NSString *)key
{
	[self setInteger:value forKey:key];
}

@end
