/*
 * PreferencesMethods.h
 * Main preference management object.
 *
 * Copyright (c) 1997 21st Century Software, New York City.
 *
 * See the file doc/LICENSE for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by David Young <david_young@thinkinc.com>, 1997.
 */

// individual preferences modules
#define HP_UNSET		0
#define HP_PORTA		1
#define HP_PORTB		2
#define HP_APPLETALK	3
#define HP_ETHERNET		4

@interface Preferences (HardwarePreferences)

- (unsigned)connectionPort;
- (void)setConnectionPort:(unsigned)portSpec;

- (BOOL)connectOnStartup;
- (void)setConnectOnStartup:(BOOL)flag;

- (unsigned)portSpeed;
- (void)setPortSpeed:(unsigned)portSpeed;

- (unsigned)timeout;
- (void)setTimeout:(unsigned)timeout;

@end

@interface Preferences (SlurpeePreferences)

- (BOOL)performsConversions;
- (void)setPerformsConversions:(BOOL)flag;

- (NSArray *)alwaysConvertExtensions;
- (NSArray *)neverConvertExtensions;

- (void)setAlwaysConvertExtensions:(NSString *)extList;
- (void)setNeverConvertExtensions:(NSString *)extList;

- (NSString *)defaultFontFamily;
- (void)setDefaultFontFamily:(NSString *)family;

- (unsigned)defaultFontSize;
- (void)setDefaultFontSize:(unsigned)size;

@end

@interface Preferences (FilingPreferences)

- (NSArray *)standardFolderList;
- (NSString *)unfiledFolderLocalizedName;

- (NSArray *)customFolderList;
- (void)setCustomFolderList:(NSArray *)theList;

- (NSString *)defaultFolderForNotes;
- (NSString *)defaultFolderForPackages;

- (void)setDefaultFolderForNotes:(NSString *)aFolder;
- (void)setDefaultFolderForPackages:(NSString *)aFolder;

@end
