#import <foundation/NSString.h>
#import <foundation/NSArray.h>

#import <TCKit/TCKit.h>

#import "SwappablePreferences.h"
#import "Preferences.h"

#import "SlurpeePreferences.h"

@implementation SlurpeePreferences

- (NSString *)windowTitle
{
	return @"Slurpee";
}

- (NSString *)buttonTitle
{
	return @"Slurpee";
}


- (BOOL)performsConversions
{
	return [Preferences integerForKey:@"PerformConversions"];
}

- (void)setPerformsConversions:(BOOL)flag
{
	[Preferences setInteger:flag forKey:@"PerformConversions"];
}

- (NSArray *)alwaysConvertExtensions;
{
	return [Preferences arrayForKey:@"AlwaysConvertExtensions"
		withSeparator:@","];
}

- (NSArray *)neverConvertExtensions;
{
	return [Preferences arrayForKey:@"NeverConvertExtensions"
		withSeparator:@","];
}

- (void)setAlwaysConvertExtensions:(NSString *)extList
{
	[Preferences setString:extList forKey:@"AlwaysConvertExtensions"];
}

- (void)setNeverConvertExtensions:(NSString *)extList
{
	[Preferences setString:extList forKey:@"NeverConvertExtensions"];
}

- (NSString *)defaultFontFamily
{
	return LOCALIZED_STRING([Preferences stringForKey:
		@"DefaultNotesFontFamily"], @"", @"");
}

- (void)setDefaultFontFamily:(NSString *)family
{
	[Preferences setString:family forKey:@"DefaultNotesFontFamily"];
}

- (unsigned)defaultFontSize
{
	return [Preferences integerForKey:@"DefaultNotesFontSize"];
}

- (void)setDefaultFontSize:(unsigned)size
{
	[Preferences setInteger:size forKey:@"DefaultNotesFontSize"];
}

- update:sender
{
	[self setPerformsConversions:[performConversionsBox intValue]];
	[self setAlwaysConvertExtensions:[NSString stringWithCString:
		[rulesForm stringValueAt:0]]];
	[self setNeverConvertExtensions:[NSString stringWithCString:
		[rulesForm stringValueAt:1]]];

	[self setDefaultFontFamily:[NSString stringWithCString:
		[[fontFamilyForm selectedCell] title]]];
	[self setDefaultFontSize:[fontSizeForm intValue]];

    return self;
}

- (void)willBecomeCurrentView:sender
{
	[super willBecomeCurrentView:sender];

	[performConversionsBox setIntValue:[self performsConversions]];
	[rulesForm setStringValue:[[[self alwaysConvertExtensions]
		componentsJoinedByString:@","] cString] at:0];
	[rulesForm setStringValue:[[[self neverConvertExtensions]
		componentsJoinedByString:@","] cString] at:1];

	[fontFamilyForm selectCell:
		[fontFamilyForm cellWithTitle:
			[[Preferences stringForKey:@"DefaultNotesFontFamily"] cString]
			inColumn:0]];
	[fontSizeForm setIntValue:[self defaultFontSize]];
}

@end
