#import "SwappablePreferences.h"

#import <foundation/NSString.h>
#import <foundation/NSArray.h>

@implementation SwappablePreferences

- (NSString *)windowTitle
{
	return @"Generic";
}

- (NSString *)buttonTitle
{
	return @"Generic";
}

- initWithParent:sender
{
	const char *nibName;

	[super init];

	[sender setTitle:[[NSString 
		stringWithFormat:@"Loading %s", [self name]] cString]];
	parent = sender;

	nibName = [[NSString stringWithFormat:@"%s.nib", [self name]] cString];
	if (controlGroup == nil) {
		if (![NXApp loadNibSection:nibName owner:self]) {
			NXRunAlertPanel ("Preferences Error", 
				"Can't load %s!", "Cancel", NULL, NULL, nibName);
	    	return nil;
		}
    }

	return self;
}

- (View *)enclosingView
{
	return controlGroup;
}

- (void)willBecomeCurrentView:sender
{
}

- (void)willResignCurrentView:sender
{
}


@end
